/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.spotify.core.util;

import de.labystudio.spotifyapi.model.Track;
import de.labystudio.spotifyapi.open.OpenSpotifyAPI;
import de.labystudio.spotifyapi.open.model.track.Image;
import de.labystudio.spotifyapi.open.model.track.OpenTrack;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import net.labymod.addons.spotify.core.Textures;
import net.labymod.addons.spotify.core.util.Cache;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.resources.CompletableResourceLocation;
import net.labymod.api.client.resources.ResourceLocation;
import net.labymod.api.client.resources.texture.GameImage;
import net.labymod.api.client.resources.texture.SimpleTexture;
import net.labymod.api.client.resources.texture.TextureDetails;
import net.labymod.api.client.resources.texture.TextureRepository;

public class TrackUtil {
    private static final Cache<Icon> ICON_CACHE = new Cache<Icon>(1800000L, icon -> {
        ResourceLocation resourceLocation = icon.getResourceLocation();
        if (Objects.equals(resourceLocation, Textures.UNKNOWN_COVER.resource())) {
            return;
        }
        Laby.references().textureRepository().queueTextureRelease(resourceLocation);
    });

    public static synchronized Icon createIcon(OpenSpotifyAPI api, Track track) {
        if (!track.isIdValid()) {
            return Icon.texture((ResourceLocation)Textures.UNKNOWN_COVER);
        }
        Icon cachedIcon = ICON_CACHE.get(track.getId());
        if (cachedIcon != null) {
            return cachedIcon;
        }
        final CompletableResourceLocation completable = new CompletableResourceLocation((ResourceLocation)Textures.UNKNOWN_COVER);
        final ResourceLocation resourceLocation = TrackUtil.getResourceLocationForTrackId(track.getId());
        BufferedImage coverArt = track.getCoverArt();
        if (coverArt == null) {
            api.requestOpenTrackAsync(track.getId(), openTrack -> TrackUtil.registerOpenTrackImage(openTrack, resourceLocation, arg_0 -> ((CompletableResourceLocation)completable).executeCompletableListeners(arg_0)));
        } else {
            GameImage gameImage = Laby.references().gameImageProvider().getImage(coverArt);
            final SimpleTexture texture = SimpleTexture.simple((ResourceLocation)resourceLocation, (GameImage)gameImage);
            texture.bindTo(new TextureRepository.TextureRegistrationCallback(){

                public void onBeforeTextureRegistration() {
                    texture.upload();
                }

                public void onAfterTextureRegistration() {
                    completable.executeCompletableListeners((Object)resourceLocation);
                }
            });
        }
        Icon icon = Icon.completable((CompletableResourceLocation)completable);
        ICON_CACHE.push(track.getId(), icon);
        return icon;
    }

    private static ResourceLocation getResourceLocationForTrackId(String trackId) {
        return Laby.references().resources().resourceLocationFactory().create("spotify", "track/" + trackId.toLowerCase(Locale.ENGLISH));
    }

    public static synchronized Icon createIcon(OpenTrack track) {
        if (!Track.isTrackIdValid((String)track.id)) {
            return Icon.texture((ResourceLocation)Textures.UNKNOWN_COVER);
        }
        Icon cachedIcon = ICON_CACHE.get(track.id);
        if (cachedIcon != null) {
            return cachedIcon;
        }
        CompletableResourceLocation completable = new CompletableResourceLocation((ResourceLocation)Textures.UNKNOWN_COVER);
        ResourceLocation resource = TrackUtil.getResourceLocationForTrackId(track.id);
        TrackUtil.registerOpenTrackImage(track, resource, arg_0 -> ((CompletableResourceLocation)completable).executeCompletableListeners(arg_0));
        Icon icon = Icon.completable((CompletableResourceLocation)completable);
        ICON_CACHE.push(track.id, icon);
        return icon;
    }

    private static synchronized void registerOpenTrackImage(OpenTrack openTrack, ResourceLocation resourceLocation, Consumer<ResourceLocation> callback) {
        Image artwork = TrackUtil.getSmallestImage(openTrack);
        if (artwork == null) {
            return;
        }
        TextureDetails details = TextureDetails.builder((ResourceLocation)resourceLocation).withUrl(artwork.url).withFinishHandler(texture -> callback.accept(resourceLocation)).build();
        TextureRepository textureRepository = Laby.references().textureRepository();
        textureRepository.getOrRegisterTexture(details);
    }

    public static List<Component> getShortTrackNameAndArtist(OpenTrack openTrack) {
        Object artist;
        Object name = openTrack.name;
        int bracketIndex = ((String)name).indexOf("(");
        if (bracketIndex != -1 && ((String)name).indexOf("Remix", bracketIndex) == -1) {
            name = ((String)name).substring(0, bracketIndex);
        }
        if (((String)name).length() > 32) {
            name = ((String)name).substring(0, 29) + "...";
        }
        if (((String)(artist = openTrack.getArtistsString())).length() > 32) {
            artist = ((String)artist).substring(0, 29) + "...";
        }
        String finalName = ((String)name).trim();
        String finalArtist = ((String)artist).trim();
        return List.of(Component.text((String)finalName), Component.text((String)finalArtist));
    }

    public static Image getSmallestImage(OpenTrack openTrack) {
        if (openTrack == null || openTrack.album == null || openTrack.album.getImages() == null) {
            return null;
        }
        Image target = null;
        for (Image image : openTrack.album.getImages()) {
            if (target != null && image.width >= target.width) continue;
            target = image;
        }
        return target;
    }
}

