/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.spotify.core.labymod.hudwidgets;

import de.labystudio.spotifyapi.SpotifyAPI;
import de.labystudio.spotifyapi.model.Track;
import net.labymod.addons.spotify.core.events.SpotifyConnectEvent;
import net.labymod.addons.spotify.core.events.SpotifyDisconnectEvent;
import net.labymod.addons.spotify.core.events.SpotifyTrackChangedEvent;
import net.labymod.api.client.gui.hud.hudwidget.text.TextHudWidget;
import net.labymod.api.client.gui.hud.hudwidget.text.TextHudWidgetConfig;
import net.labymod.api.client.gui.hud.hudwidget.text.TextLine;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.event.Subscribe;

public class SpotifyTextHudWidget
extends TextHudWidget<TextHudWidgetConfig> {
    private TextLine trackLine;
    private TextLine artistLine;
    private final Icon hudWidgetIcon;
    private final SpotifyAPI spotifyAPI;

    public SpotifyTextHudWidget(String id, Icon icon, SpotifyAPI spotifyAPI) {
        super(id);
        this.hudWidgetIcon = icon;
        this.spotifyAPI = spotifyAPI;
    }

    public void load(TextHudWidgetConfig config) {
        super.load(config);
        this.trackLine = super.createLine("Track", (Object)"Loading...");
        this.artistLine = super.createLine("Artist", (Object)"Loading...");
        this.setIcon(this.hudWidgetIcon);
        this.updateTrack();
    }

    public boolean isVisibleInGame() {
        return this.spotifyAPI.isConnected() && this.spotifyAPI.isPlaying();
    }

    @Subscribe
    public void onSpotifyConnect(SpotifyConnectEvent event) {
        this.updateTrack();
    }

    @Subscribe
    public void onSpotifyDisconnect(SpotifyDisconnectEvent event) {
        this.updateTrack();
    }

    @Subscribe
    public void onSpotifyTrackChangedEvent(SpotifyTrackChangedEvent event) {
        this.updateTrack();
    }

    public void updateTrack() {
        if (this.trackLine == null || this.artistLine == null) {
            return;
        }
        if (this.spotifyAPI.isPlaying()) {
            Track track = this.spotifyAPI.getTrack();
            if (track == null) {
                this.trackLine.updateAndFlush((Object)"Not playing");
                this.artistLine.updateAndFlush((Object)"Not playing");
            } else {
                this.trackLine.updateAndFlush((Object)track.getName());
                this.artistLine.updateAndFlush((Object)track.getArtist());
            }
        } else {
            this.trackLine.updateAndFlush((Object)"Not playing");
            this.artistLine.updateAndFlush((Object)"Not playing");
        }
    }
}

