/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.spotify.core.labymod.snapshot;

import net.labymod.addons.spotify.core.SpotifyAddon;
import net.labymod.addons.spotify.core.SpotifyConfiguration;
import net.labymod.addons.spotify.core.sharing.SharedTrack;
import net.labymod.addons.spotify.core.sharing.TrackSharingController;
import net.labymod.api.client.entity.player.Player;
import net.labymod.api.laby3d.renderer.snapshot.AbstractLabySnapshot;
import net.labymod.api.laby3d.renderer.snapshot.Extras;
import org.jetbrains.annotations.Nullable;

public class SpotifyUserSnapshot
extends AbstractLabySnapshot {
    private final SharedTrack track;
    private final boolean displayExplicitTracks;
    private final boolean displayTrackCover;

    public SpotifyUserSnapshot(Player player, Extras extras, SpotifyAddon addon) {
        super(extras);
        SpotifyConfiguration configuration = (SpotifyConfiguration)addon.configuration();
        this.track = this.resolveTrack(player, configuration, addon.getController());
        this.displayExplicitTracks = (Boolean)configuration.displayExplicitTracks().get();
        this.displayTrackCover = (Boolean)configuration.displayTrackCover().get();
    }

    @Nullable
    public SharedTrack getTrack() {
        return this.track;
    }

    public boolean displayExplicitTracks() {
        return this.displayExplicitTracks;
    }

    public boolean displayTrackCover() {
        return this.displayTrackCover;
    }

    private SharedTrack resolveTrack(Player player, SpotifyConfiguration configuration, TrackSharingController controller) {
        if (!((Boolean)configuration.enabled().get()).booleanValue()) {
            return null;
        }
        if (!((Boolean)configuration.displayTracks().get()).booleanValue()) {
            return null;
        }
        return controller.getTrackOf(player.getUniqueId());
    }
}

