/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.spotify.core.api;

import de.labystudio.spotifyapi.SpotifyAPI;
import de.labystudio.spotifyapi.SpotifyListener;
import de.labystudio.spotifyapi.model.Track;
import net.labymod.addons.spotify.core.SpotifyAddon;
import net.labymod.addons.spotify.core.events.SpotifyConnectEvent;
import net.labymod.addons.spotify.core.events.SpotifyDisconnectEvent;
import net.labymod.addons.spotify.core.events.SpotifyPlaybackChangedEvent;
import net.labymod.addons.spotify.core.events.SpotifyPositionChangedEvent;
import net.labymod.addons.spotify.core.events.SpotifyTrackChangedEvent;
import net.labymod.addons.spotify.core.util.ReconnectDelay;
import net.labymod.api.LabyAPI;
import net.labymod.api.event.Event;

public class SpotifyApiListener
implements SpotifyListener {
    private final SpotifyAPI spotifyAPI;
    private final SpotifyAddon spotifyAddon;
    private final LabyAPI labyAPI;

    public SpotifyApiListener(SpotifyAPI spotifyAPI, SpotifyAddon spotifyAddon) {
        this.spotifyAPI = spotifyAPI;
        this.spotifyAddon = spotifyAddon;
        this.labyAPI = spotifyAddon.labyAPI();
    }

    public void onConnect() {
        this.labyAPI.eventBus().fire((Event)new SpotifyConnectEvent());
    }

    public void onTrackChanged(Track track) {
        this.labyAPI.eventBus().fire((Event)new SpotifyTrackChangedEvent(track));
    }

    public void onPositionChanged(int position) {
        Track track = this.spotifyAPI.getTrack();
        this.labyAPI.eventBus().fire((Event)new SpotifyPositionChangedEvent(track, position));
        if (position > 0) {
            this.spotifyAddon.setReconnectDelay(ReconnectDelay.DEFAULT);
        }
    }

    public void onPlayBackChanged(boolean isPlaying) {
        Track track = this.spotifyAPI.getTrack();
        this.labyAPI.eventBus().fire((Event)new SpotifyPlaybackChangedEvent(track, isPlaying));
    }

    public void onSync() {
    }

    public void onDisconnect(Exception exception) {
        this.labyAPI.eventBus().fire((Event)new SpotifyDisconnectEvent());
        this.spotifyAddon.bumpReconnectDelay();
        this.spotifyAddon.initializeSpotifyAndResetDelay(true);
    }
}

