/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.spotify.core.labymod.interaction;

import net.labymod.addons.spotify.core.SpotifyAddon;
import net.labymod.addons.spotify.core.SpotifyConfiguration;
import net.labymod.addons.spotify.core.sharing.SharedTrack;
import net.labymod.addons.spotify.core.sharing.TrackSharingController;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.entity.player.Player;
import net.labymod.api.client.entity.player.interaction.AbstractBulletPoint;
import net.labymod.api.models.OperatingSystem;

public class SpotifyTrackBulletPoint
extends AbstractBulletPoint {
    private static final String URL = "https://open.spotify.com/track/%s?si=labymod_spotify";
    private final SpotifyAddon spotifyAddon;
    private final TrackSharingController broadcastController;

    public SpotifyTrackBulletPoint(SpotifyAddon spotifyAddon, TrackSharingController broadcastController) {
        super((Component)Component.translatable((String)"spotify.bulletPoint.open.name", (Component[])new Component[0]));
        this.spotifyAddon = spotifyAddon;
        this.broadcastController = broadcastController;
    }

    public void execute(Player player) {
        SharedTrack track = this.broadcastController.getTrackOf(player.getUniqueId());
        if (track == null) {
            return;
        }
        OperatingSystem.getPlatform().openUri(String.format(URL, track.getTrackId()));
    }

    public boolean isVisible(Player player) {
        SpotifyConfiguration configuration = (SpotifyConfiguration)this.spotifyAddon.configuration();
        if (!((Boolean)configuration.enabled().get()).booleanValue() || !((Boolean)configuration.displayTracks().get()).booleanValue()) {
            return false;
        }
        return this.broadcastController.hasTrack(player.getUniqueId());
    }
}

