/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.spotify.core.labymod.nametag;

import net.labymod.addons.spotify.core.SpotifyConfiguration;
import net.labymod.addons.spotify.core.sharing.SharedTrack;
import net.labymod.addons.spotify.core.sharing.TrackSharingController;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.entity.player.Player;
import net.labymod.api.client.entity.player.tag.tags.NameTag;
import net.labymod.api.client.gui.HorizontalAlignment;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.render.RenderPipeline;
import net.labymod.api.client.render.draw.RectangleRenderer;
import net.labymod.api.client.render.font.RenderableComponent;
import net.labymod.api.client.render.matrix.Stack;
import org.jetbrains.annotations.Nullable;

public class SpotifySharedTrack
extends NameTag {
    private final RenderPipeline renderPipeline;
    private final RectangleRenderer rectangleRenderer;
    private final TrackSharingController controller;
    private boolean enabled;
    private boolean displayTracks;
    private boolean displayExplicitTracks;
    private boolean displayTrackCover;

    public SpotifySharedTrack(SpotifyConfiguration configuration, TrackSharingController controller) {
        this.controller = controller;
        this.renderPipeline = Laby.references().renderPipeline();
        this.rectangleRenderer = this.renderPipeline.rectangleRenderer();
        this.enabled = configuration.getAndAddListener(configuration.enabled(), value -> {
            this.enabled = value;
        });
        this.displayTracks = configuration.getAndAddListener(configuration.displayTracks(), value -> {
            this.displayTracks = value;
        });
        this.displayExplicitTracks = configuration.getAndAddListener(configuration.displayExplicitTracks(), value -> {
            this.displayExplicitTracks = value;
        });
        this.displayTrackCover = configuration.getAndAddListener(configuration.displayTrackCover(), value -> {
            this.displayTrackCover = value;
        });
    }

    @Nullable
    protected RenderableComponent getRenderableComponent() {
        if (!(this.entity instanceof Player) || this.entity.isCrouching()) {
            return null;
        }
        if (!this.enabled || !this.displayTracks) {
            return null;
        }
        SharedTrack track = this.controller.getTrackOf(this.entity.getUniqueId());
        if (track == null) {
            return null;
        }
        if (track.isExplicit() && !this.displayExplicitTracks) {
            return null;
        }
        Component component = track.getComponent();
        if (component == null) {
            return null;
        }
        HorizontalAlignment alignment = track.getIcon() == null || !this.displayTrackCover ? HorizontalAlignment.CENTER : HorizontalAlignment.LEFT;
        return RenderableComponent.of((Component)component, (HorizontalAlignment)alignment);
    }

    protected void renderText(Stack stack, RenderableComponent component, boolean discrete, int textColor, int backgroundColor, float x, float y) {
        Icon icon;
        float width = this.getWidth();
        float height = this.getHeight();
        stack.push();
        stack.translate(0.0f, 0.0f, -0.03f);
        this.rectangleRenderer.renderRectangle(stack, x, y, width, height, backgroundColor);
        stack.pop();
        float textX = x;
        SharedTrack track = this.controller.getTrackOf(this.entity.getUniqueId());
        if (track != null && this.displayTrackCover && (icon = track.getIcon()) != null) {
            this.renderPipeline.renderSeeThrough(this.entity, () -> {
                float size = height - 2.0f;
                float iconX = x + 1.0f;
                float iconY = y + 1.0f;
                float progressY = iconY + size - 1.0f;
                icon.render(stack, iconX, iconY, size);
                double progress = track.getDaemonProgress();
                if (progress > 0.0) {
                    boolean progressHeight = true;
                    stack.push();
                    stack.translate(0.0f, 0.0f, 0.003f);
                    this.rectangleRenderer.renderRectangle(stack, iconX, progressY, iconX + size, progressY + (float)progressHeight, -13421773);
                    stack.translate(0.0f, 0.0f, 0.003f);
                    this.rectangleRenderer.renderRectangle(stack, iconX, progressY, (float)((double)iconX + (double)size * progress), progressY + (float)progressHeight, -16711936);
                    stack.pop();
                }
            });
            textX += height + 1.0f;
        }
        super.renderText(stack, component, discrete, textColor, 0, textX, y + 1.0f);
    }

    public float getScale() {
        return 0.5f;
    }

    public float getWidth() {
        return super.getWidth() + (this.displayTrackCover ? this.getHeight() : 0.0f);
    }

    public float getHeight() {
        return super.getHeight() + 1.0f;
    }
}

