/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.spotify.core.labymod.nametag;

import java.util.List;
import net.labymod.addons.spotify.core.labymod.snapshot.SpotifyExtraKeys;
import net.labymod.addons.spotify.core.labymod.snapshot.SpotifyUserSnapshot;
import net.labymod.addons.spotify.core.sharing.SharedTrack;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.entity.player.tag.tags.ComponentNameTag;
import net.labymod.api.client.gui.HorizontalAlignment;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.render.matrix.Stack;
import net.labymod.api.client.render.state.entity.AvatarSnapshot;
import net.labymod.api.client.render.state.entity.EntitySnapshot;
import net.labymod.api.laby3d.pipeline.RenderStates;
import net.labymod.api.laby3d.pipeline.material.LevelMaterial;
import net.labymod.api.laby3d.pipeline.material.Material;
import net.labymod.api.laby3d.render.queue.CustomGeometryRenderer;
import net.labymod.api.laby3d.render.queue.SubmissionCollector;
import net.labymod.api.laby3d.render.queue.submissions.IconSubmission;
import net.labymod.api.loader.MinecraftVersions;
import net.labymod.laby3d.api.pipeline.RenderState;
import net.labymod.laby3d.api.vertex.VertexConsumer;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class SpotifySharedTrack
extends ComponentNameTag {
    private static final boolean INVERSE_DEPTH = MinecraftVersions.V1_20_6.orOlder();
    private static final float BACKGROUND_DEPTH = -0.03f;
    private static final float PROGRESS_BACKGROUND_BAR_DEPTH = 0.03f;
    private static final float PROGRESS_PROGRESS_BAR_DEPTH = 0.04f;
    private static final int PROGRESS_BAR_BACKGROUND_COLOR = -13421773;
    private static final int PROGRESS_BAR_COLOR = -16711936;
    private Icon icon;
    private double progress;
    private HorizontalAlignment alignment = HorizontalAlignment.CENTER;

    @NotNull
    protected List<Component> buildComponents(EntitySnapshot snapshot) {
        AvatarSnapshot avatar;
        EntitySnapshot entitySnapshot = this.snapshot;
        if (!(entitySnapshot instanceof AvatarSnapshot) || (avatar = (AvatarSnapshot)entitySnapshot).isDiscrete()) {
            return super.buildComponents(snapshot);
        }
        if (!this.snapshot.has(SpotifyExtraKeys.SPOTIFY_USER)) {
            return super.buildComponents(snapshot);
        }
        SpotifyUserSnapshot spotifyUser = (SpotifyUserSnapshot)((Object)this.snapshot.get(SpotifyExtraKeys.SPOTIFY_USER));
        SharedTrack track = spotifyUser.getTrack();
        if (track == null) {
            return super.buildComponents(snapshot);
        }
        if (track.isExplicit() && !spotifyUser.displayExplicitTracks()) {
            return super.buildComponents(snapshot);
        }
        this.icon = spotifyUser.displayTrackCover() ? track.getIcon() : null;
        this.alignment = this.icon == null ? HorizontalAlignment.CENTER : HorizontalAlignment.LEFT;
        this.progress = track.getDaemonProgress();
        return track.getComponents();
    }

    public void render(Stack stack, SubmissionCollector submissionCollector, EntitySnapshot snapshot) {
        float size = this.getHeight();
        float backgroundWidth = this.getWidth();
        Material guiMaterial = LevelMaterial.builder((RenderState)RenderStates.GUI).build();
        int backgroundArgb = Laby.labyAPI().minecraft().options().getBackgroundColorWithOpacity(DEFAULT_BACKGROUND_COLOR);
        submissionCollector.submitCustomGeometry(stack, guiMaterial, (CustomGeometryRenderer)new ColoredRectangle(-1.0f, -1.0f, backgroundWidth + 1.0f, size + 1.0f, INVERSE_DEPTH ? 0.03f : -0.03f, backgroundArgb));
        super.render(stack, submissionCollector, snapshot);
        if (this.icon != null) {
            submissionCollector.submitIcon(stack, this.icon, IconSubmission.DisplayMode.NORMAL, 0.0f, 0.0f, size, size, -1);
            if (this.progress > 0.0) {
                float progressBarTop = size - 1.0f;
                submissionCollector.submitCustomGeometry(stack, guiMaterial, (CustomGeometryRenderer)new ColoredRectangle(0.0f, progressBarTop, size, size, INVERSE_DEPTH ? -0.03f : 0.03f, -13421773));
                submissionCollector.submitCustomGeometry(stack, guiMaterial, (CustomGeometryRenderer)new ColoredRectangle(0.0f, progressBarTop, (float)((double)size * this.progress), size, INVERSE_DEPTH ? -0.04f : 0.04f, -16711936));
            }
        }
    }

    protected void submitText(Stack stack, SubmissionCollector submissionCollector, EntitySnapshot snapshot, Component component, float xOffset, float yOffset) {
        if (this.alignment == HorizontalAlignment.LEFT) {
            xOffset = this.getHeight() + 1.0f;
        } else if (this.alignment == HorizontalAlignment.CENTER) {
            xOffset = (this.getWidth() - this.fontRenderer.getWidth(component)) / 2.0f;
        }
        submissionCollector.order(3).submitComponent(stack, component, xOffset, yOffset, DEFAULT_TEXT_COLOR, snapshot.lightCoords(), this.getBackgroundColor(snapshot), 4);
    }

    protected int getBackgroundColor(EntitySnapshot snapshot) {
        return 0;
    }

    public float getScale() {
        return 0.5f;
    }

    public float getWidth() {
        return super.getWidth() + (this.icon != null ? this.getHeight() : 0.0f);
    }

    public float getHeight() {
        return super.getHeight();
    }

    public boolean isDiscrete(EntitySnapshot snapshot) {
        return true;
    }

    static class ColoredRectangle
    implements CustomGeometryRenderer {
        private final float left;
        private final float top;
        private final float right;
        private final float bottom;
        private final float depth;
        private final int argb;

        public ColoredRectangle(float left, float top, float right, float bottom, float depth, int argb) {
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
            this.depth = depth;
            this.argb = argb;
        }

        public void render(Matrix4f pose, VertexConsumer consumer) {
            consumer.addVertex(pose, this.left, this.top, this.depth).setBlankUv().setColor(this.argb);
            consumer.addVertex(pose, this.left, this.bottom, this.depth).setBlankUv().setColor(this.argb);
            consumer.addVertex(pose, this.right, this.bottom, this.depth).setBlankUv().setColor(this.argb);
            consumer.addVertex(pose, this.right, this.top, this.depth).setBlankUv().setColor(this.argb);
        }
    }
}

