/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.spotify.core.sharing;

import de.labystudio.spotifyapi.open.OpenSpotifyAPI;
import de.labystudio.spotifyapi.open.model.track.OpenTrack;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.labymod.addons.spotify.core.util.TrackUtil;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.session.Session;
import net.labymod.api.util.Debounce;
import net.labymod.api.util.math.MathHelper;
import net.labymod.api.util.time.TimeUtil;
import org.jetbrains.annotations.Nullable;

public class SharedTrack {
    private final OpenSpotifyAPI openApi;
    private final String trackId;
    private final UUID userId;
    private final boolean isSelf;
    private boolean resolveRequired = true;
    private OpenTrack openTrack;
    private List<Component> components = Collections.emptyList();
    private Icon icon;
    private int position = 0;
    private long timeLastPositionUpdated = 0L;

    public SharedTrack(OpenSpotifyAPI openApi, UUID userId, String trackId) {
        this.openApi = openApi;
        this.userId = userId;
        this.trackId = trackId;
        Session session = Laby.labyAPI().minecraft().sessionAccessor().getSession();
        this.isSelf = session != null && session.getUniqueId().equals(userId);
    }

    public void updatePosition(int position) {
        this.position = position;
        this.timeLastPositionUpdated = TimeUtil.getCurrentTimeMillis();
    }

    public String getTrackId() {
        return this.trackId;
    }

    public double getDaemonProgress() {
        Integer maxPosition;
        if (this.resolveRequired) {
            this.resolve();
        }
        Integer n = maxPosition = this.openTrack == null ? null : this.openTrack.durationMs;
        if (maxPosition == null || maxPosition <= 0 || this.position <= 0 || this.position > maxPosition) {
            return 0.0;
        }
        long elapsedTime = TimeUtil.getCurrentTimeMillis() - this.timeLastPositionUpdated + this.getResolveDelay() + 1000L;
        double progress = (double)((long)this.position + elapsedTime) / (double)maxPosition.intValue();
        return MathHelper.clamp((double)progress, (double)0.0, (double)1.0);
    }

    @Nullable
    public Icon getIcon() {
        if (this.resolveRequired) {
            this.resolve();
        }
        return this.icon;
    }

    public List<Component> getComponents() {
        if (this.resolveRequired) {
            this.resolve();
        }
        return this.components;
    }

    public boolean isExplicit() {
        if (this.resolveRequired) {
            this.resolve();
        }
        return this.openTrack != null && this.openTrack.explicit != false;
    }

    private void resolve() {
        this.resolveRequired = false;
        Debounce.of((String)("spotifyResolve:" + this.userId.toString()), (long)this.getResolveDelay(), () -> this.openApi.requestOpenTrackAsync(this.trackId, resolvedTrack -> {
            if (resolvedTrack == null) {
                return;
            }
            this.openTrack = resolvedTrack;
            this.icon = TrackUtil.createIcon(resolvedTrack);
            this.components = TrackUtil.getShortTrackNameAndArtist(resolvedTrack);
        }));
    }

    private long getResolveDelay() {
        return this.isSelf ? 100L : 1000L;
    }
}

