/*
 * Decompiled with CFR 0.152.
 */
package de.raik.tnttimer.core;

import de.raik.tnttimer.core.TNTTimerAddon;
import de.raik.tnttimer.core.TNTTimerConfig;
import java.text.DecimalFormat;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.entity.Entity;
import net.labymod.api.client.entity.item.PrimedTnt;
import net.labymod.api.client.entity.player.tag.event.NameTagBackgroundRenderEvent;
import net.labymod.api.client.entity.player.tag.tags.NameTag;
import net.labymod.api.client.gfx.GFXBridge;
import net.labymod.api.client.options.MinecraftOptions;
import net.labymod.api.client.render.font.RenderableComponent;
import net.labymod.api.client.render.matrix.Stack;
import net.labymod.api.loader.platform.PlatformEnvironment;
import net.labymod.api.util.ColorUtil;
import net.labymod.api.util.math.MathHelper;

public class TNTTimeTag
extends NameTag {
    private final TNTTimerAddon addon;
    private final DecimalFormat decimalFormat = new DecimalFormat("0.00");
    private final MinecraftOptions options;

    public TNTTimeTag(TNTTimerAddon addon) {
        this.addon = addon;
        this.options = addon.labyAPI().minecraft().options();
    }

    private TextColor getColor() {
        if (!((Boolean)((TNTTimerConfig)this.addon.configuration()).colored().get()).booleanValue()) {
            return NamedTextColor.WHITE;
        }
        int green = MathHelper.clamp((int)(255 * ((PrimedTnt)this.entity).getFuse() / 80), (int)0, (int)255);
        return TextColor.color((int)(255 - green), (int)green, (int)0);
    }

    private String getTag() {
        float number = (float)((PrimedTnt)this.entity).getFuse() / 20.0f;
        if (number < 0.0f) {
            return null;
        }
        return this.decimalFormat.format(number);
    }

    public void render(Stack stack, Entity entity) {
        GFXBridge gfx = this.addon.labyAPI().gfxRenderPipeline().gfx();
        gfx.storeBlaze3DStates();
        gfx.depthMask(false);
        if (!PlatformEnvironment.isAncientOpenGL()) {
            gfx.enableDepth();
        }
        gfx.enableBlend();
        gfx.defaultBlend();
        this.renderBackground(stack);
        gfx.depthMask(true);
        if (PlatformEnvironment.isAncientOpenGL()) {
            gfx.enableDepth();
        }
        this.renderText(stack, this.getRenderableComponent(), false, 0x20FFFFFF, 1.0f, 0.5f);
        this.renderText(stack, this.getRenderableComponent(), false, -1, 1.0f, 0.5f);
        gfx.restoreBlaze3DStates();
    }

    private void renderBackground(Stack stack) {
        NameTagBackgroundRenderEvent event = NameTagBackgroundRenderEvent.singleton();
        if (event.isCancelled()) {
            return;
        }
        int alpha = (int)((float)this.options.getBackgroundColorWithOpacity(192) * 255.0f);
        int backgroundColor = ColorUtil.toValue((int)event.getColor(), (int)alpha);
        this.renderBackground(stack, -1.0f, 0.0f, this.getWidth(), this.getHeight(), backgroundColor);
    }

    protected RenderableComponent getRenderableComponent() {
        if (!this.addon.labyAPI().permissionRegistry().isPermissionEnabled("tnttimer", ((TNTTimerConfig)this.addon.configuration()).enabled())) {
            return null;
        }
        if (!(this.entity instanceof PrimedTnt)) {
            return null;
        }
        String tag = this.getTag();
        if (tag == null) {
            return null;
        }
        return RenderableComponent.of((Component)Component.text((String)tag).color(this.getColor()));
    }
}

