/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.togglesneak.core.controller;

import net.labymod.api.Laby;
import net.labymod.api.client.options.MinecraftInputMapping;
import net.labymod.api.client.options.MinecraftOptions;
import net.labymod.api.client.options.ToggleInputMapping;
import net.labymod.api.event.Phase;
import net.labymod.api.reference.annotation.Referenceable;
import net.labymod.api.util.Lazy;
import org.jetbrains.annotations.Nullable;

@Nullable
@Referenceable
public abstract class ToggleSneakController {
    private static final Lazy<MinecraftOptions> MINECRAFT_OPTIONS = Lazy.of(() -> Laby.labyAPI().minecraft().options());

    public abstract Phase phase();

    public void test() {
    }

    public boolean isSprintPressed() {
        return this.sprintInputMapping().isActuallyDown();
    }

    public boolean isSneakPressed() {
        return this.sneakInputMapping().isActuallyDown();
    }

    public void setSprinting(boolean sprinting) {
        this.update(this.sprintInputMapping(), sprinting);
    }

    public void setSneaking(boolean sneaking) {
        this.update(this.sneakInputMapping(), sneaking);
    }

    private MinecraftInputMapping sprintInputMapping() {
        return ((MinecraftOptions)MINECRAFT_OPTIONS.get()).sprintInput();
    }

    private MinecraftInputMapping sneakInputMapping() {
        return ((MinecraftOptions)MINECRAFT_OPTIONS.get()).sneakInput();
    }

    private void update(MinecraftInputMapping inputMapping, boolean press) {
        if (!(inputMapping instanceof ToggleInputMapping)) {
            if (press == inputMapping.isDown()) {
                return;
            }
            if (press) {
                inputMapping.press();
            } else {
                inputMapping.unpress();
            }
            return;
        }
        ToggleInputMapping toggleInputMapping = (ToggleInputMapping)inputMapping;
        if (press) {
            toggleInputMapping.forcePress();
        } else {
            toggleInputMapping.forceUnpress();
        }
    }
}

