/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.togglesneak.core.hudwidget;

import net.labymod.addons.togglesneak.core.service.ToggleSneakService;
import net.labymod.api.client.entity.player.ClientPlayer;
import net.labymod.api.client.gui.hud.hudwidget.HudWidgetConfig;
import net.labymod.api.client.gui.hud.hudwidget.text.TextHudWidget;
import net.labymod.api.client.gui.hud.hudwidget.text.TextHudWidgetConfig;
import net.labymod.api.client.gui.hud.hudwidget.text.TextLine;
import net.labymod.api.util.TextFormat;
import net.labymod.api.util.bounds.area.RectangleAreaPosition;

public class ToggleSneakHudWidget
extends TextHudWidget<TextHudWidgetConfig> {
    private final ToggleSneakService service;
    private TextLine sprintingLine;
    private TextLine sneakingLine;
    private State lastSprintState;
    private State lastSneakState;

    public ToggleSneakHudWidget(ToggleSneakService service) {
        super("toggleSneak");
        this.service = service;
    }

    public void initializePreConfigured(TextHudWidgetConfig config) {
        super.initializePreConfigured((HudWidgetConfig)config);
        config.setEnabled(true);
        config.setAreaIdentifier(RectangleAreaPosition.TOP_RIGHT);
        config.setX(-2.0f);
        config.setY(2.0f);
        config.setParentToTailOfChainIn(RectangleAreaPosition.TOP_RIGHT);
    }

    public void load(TextHudWidgetConfig config) {
        super.load(config);
        this.lastSprintState = null;
        this.sprintingLine = super.createLine("Sprinting", (Object)"");
        this.updateSprintingTextLine(State.NO);
        this.lastSneakState = null;
        this.sneakingLine = super.createLine("Sneaking", (Object)"");
        this.updateSneakingTextLine(State.NO);
    }

    public void onTick(boolean isEditorContext) {
        State currentSneakState = State.NO;
        ClientPlayer clientPlayer = this.labyAPI.minecraft().getClientPlayer();
        if (clientPlayer != null && !clientPlayer.isSprinting()) {
            if (this.service.isSneakToggled()) {
                currentSneakState = State.TOGGLED;
            } else if (this.service.isSneakPressed()) {
                currentSneakState = State.HOLDING;
            }
        }
        this.updateSneakingTextLine(currentSneakState);
        State currentCrouchState = State.NO;
        if (clientPlayer != null && currentSneakState == State.NO) {
            if (this.service.isSprintToggled()) {
                currentCrouchState = State.TOGGLED;
            } else if (this.service.isSprintPressed()) {
                currentCrouchState = State.HOLDING;
            } else if (clientPlayer.isSprinting()) {
                currentCrouchState = State.VANILLA;
            }
        }
        this.updateSprintingTextLine(currentCrouchState);
    }

    private void updateSprintingTextLine(State currentState) {
        if (this.lastSprintState == currentState) {
            return;
        }
        this.lastSprintState = currentState;
        this.sprintingLine.updateAndFlush((Object)TextFormat.SNAKE_CASE.toUpperCamelCase(currentState.name()));
        this.sprintingLine.setVisible(currentState != State.NO);
    }

    private void updateSneakingTextLine(State currentState) {
        if (this.lastSneakState == currentState) {
            return;
        }
        this.lastSneakState = currentState;
        this.sneakingLine.updateAndFlush((Object)TextFormat.SNAKE_CASE.toUpperCamelCase(currentState.name()));
        this.sneakingLine.setVisible(currentState != State.NO);
    }

    private static enum State {
        VANILLA,
        HOLDING,
        TOGGLED,
        NO;

    }
}

