/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.togglesneak.core.service;

import net.labymod.addons.togglesneak.core.ToggleSneakConfiguration;
import net.labymod.api.LabyAPI;
import net.labymod.api.client.Minecraft;
import net.labymod.api.client.entity.player.GameMode;
import net.labymod.api.client.entity.player.Player;
import net.labymod.api.client.entity.player.abilities.PlayerAbilities;

public class FlyBoostService {
    private final LabyAPI labyAPI;
    private final ToggleSneakConfiguration configuration;
    private Float originalFlySpeed = null;

    public FlyBoostService(LabyAPI labyAPI, ToggleSneakConfiguration configuration) {
        this.labyAPI = labyAPI;
        this.configuration = configuration;
        Minecraft minecraft = labyAPI.minecraft();
        if (minecraft.isIngame() && minecraft.getClientPlayer() != null) {
            this.originalFlySpeed = Float.valueOf(minecraft.getClientPlayer().abilities().flyingSpeed().get());
        }
    }

    public Float getOriginalFlySpeed() {
        return this.originalFlySpeed;
    }

    public void setOriginalFlySpeed(Float originalFlySpeed) {
        this.originalFlySpeed = originalFlySpeed;
    }

    public void applyFlyBoost(Player player) {
        PlayerAbilities abilities = player.abilities();
        if (!abilities.flying().get() || player.gameMode() != GameMode.CREATIVE && (player.gameMode() != GameMode.SPECTATOR || !((Boolean)this.configuration.overwriteSpectatorFlyBoost().get()).booleanValue()) || this.originalFlySpeed == null) {
            return;
        }
        abilities.flyingSpeed().set(this.originalFlySpeed.floatValue() * (this.isEnabled(player) ? ((Float)this.configuration.flyBoostFactor().get()).floatValue() : 1.0f));
    }

    private boolean isEnabled(Player player) {
        if (!player.isSprinting() && ((Boolean)this.configuration.flyBoostOnlyWhileSprinting().get()).booleanValue()) {
            return false;
        }
        return this.labyAPI.permissionRegistry().isPermissionEnabled("flyboost", this.configuration.flyBoost());
    }
}

