/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.togglesneak.core.listener;

import net.labymod.addons.togglesneak.core.service.FlyBoostService;
import net.labymod.api.LabyAPI;
import net.labymod.api.client.entity.player.ClientPlayer;
import net.labymod.api.client.entity.player.Player;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.client.entity.player.ClientPlayerAbilitiesUpdateEvent;
import net.labymod.api.event.client.lifecycle.GameTickEvent;
import net.labymod.api.event.client.world.WorldEnterEvent;
import net.labymod.api.event.client.world.WorldLeaveEvent;

public class FlyBoostListener {
    private final LabyAPI labyAPI;
    private final FlyBoostService service;

    public FlyBoostListener(LabyAPI labyAPI, FlyBoostService service) {
        this.labyAPI = labyAPI;
        this.service = service;
    }

    @Subscribe
    public void onAbilitiesUpdate(ClientPlayerAbilitiesUpdateEvent event) {
        this.service.setOriginalFlySpeed(Float.valueOf(event.abilities().flyingSpeed().get()));
    }

    @Subscribe
    public void onGameTick(GameTickEvent event) {
        ClientPlayer clientPlayer = this.labyAPI.minecraft().getClientPlayer();
        if (clientPlayer != null) {
            this.service.applyFlyBoost((Player)clientPlayer);
        }
    }

    @Subscribe
    public void onWorldEnter(WorldEnterEvent event) {
        ClientPlayer clientPlayer = this.labyAPI.minecraft().getClientPlayer();
        if (clientPlayer != null && event.type() == WorldEnterEvent.Type.SINGLEPLAYER) {
            this.service.setOriginalFlySpeed(Float.valueOf(clientPlayer.abilities().flyingSpeed().get()));
        }
    }

    @Subscribe
    public void onWorldLeave(WorldLeaveEvent event) {
        ClientPlayer clientPlayer = this.labyAPI.minecraft().getClientPlayer();
        Float flySpeed = this.service.getOriginalFlySpeed();
        if (clientPlayer != null && flySpeed != null) {
            clientPlayer.abilities().flyingSpeed().set(flySpeed.floatValue());
        }
        this.service.setOriginalFlySpeed(null);
    }
}

