/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.togglesneak.core.listener;

import net.labymod.addons.togglesneak.core.ToggleSneak;
import net.labymod.addons.togglesneak.core.ToggleSneakConfiguration;
import net.labymod.addons.togglesneak.core.controller.ToggleSneakController;
import net.labymod.addons.togglesneak.core.service.ToggleSneakService;
import net.labymod.api.LabyAPI;
import net.labymod.api.client.Minecraft;
import net.labymod.api.client.entity.player.ClientPlayer;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.client.lifecycle.GameTickEvent;

public class ToggleSneakListener {
    private final ToggleSneak toggleSneak;
    private final LabyAPI labyAPI;
    private final ToggleSneakService service;
    private final ToggleSneakController controller;

    public ToggleSneakListener(ToggleSneak toggleSneak, ToggleSneakController controller, ToggleSneakService service, LabyAPI labyAPI) {
        this.toggleSneak = toggleSneak;
        this.labyAPI = labyAPI;
        this.service = service;
        this.controller = controller;
    }

    @Subscribe
    public void onGameTick(GameTickEvent event) {
        if (event.phase() != this.controller.phase()) {
            return;
        }
        Minecraft minecraft = this.labyAPI.minecraft();
        ClientPlayer clientPlayer = minecraft.getClientPlayer();
        if (clientPlayer == null) {
            return;
        }
        boolean reset = minecraft.minecraftWindow().currentScreen() != null;
        this.applyToggleSprint(clientPlayer, reset);
        this.applyToggleSneak(clientPlayer, reset);
    }

    private void applyToggleSprint(ClientPlayer clientPlayer, boolean reset) {
        if (!((Boolean)((ToggleSneakConfiguration)this.toggleSneak.configuration()).toggleSprint().get()).booleanValue()) {
            this.service.setSprintPressed(false);
            this.service.toggleSprint(false);
            return;
        }
        if (!reset) {
            boolean lastPressed = this.service.isSprintPressed();
            boolean sprintPressed = this.controller.isSprintPressed();
            if (sprintPressed) {
                if (!lastPressed) {
                    this.service.setSprintPressed(true);
                    this.service.toggleSprint();
                }
            } else if (lastPressed) {
                this.service.setSprintPressed(false);
            }
        }
        this.controller.setSprinting(!reset && clientPlayer.getForwardMovingSpeed() > 0.0f && (this.service.isSprintToggled() || this.controller.isSprintPressed()));
    }

    private void applyToggleSneak(ClientPlayer clientPlayer, boolean reset) {
        ToggleSneakConfiguration configuration = (ToggleSneakConfiguration)this.toggleSneak.configuration();
        if (!((Boolean)configuration.toggleSneak().get()).booleanValue() || clientPlayer.isSprinting() || clientPlayer.isAbilitiesFlying() && ((Boolean)configuration.toggleSneakDisableWhileFlying().get()).booleanValue()) {
            this.service.setSneakPressed(false);
            this.service.toggleSneak(false);
            return;
        }
        boolean sneakPressed = this.controller.isSneakPressed();
        if (!reset) {
            boolean lastPressed = this.service.isSneakPressed();
            if (sneakPressed) {
                if (!lastPressed) {
                    this.service.setSneakPressed(true);
                    this.service.toggleSneak();
                }
            } else if (lastPressed) {
                this.service.setSneakPressed(false);
            }
        }
        this.controller.setSneaking(!reset && (sneakPressed || this.service.isSneakToggled()));
    }
}

