/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.toolwarn;

import com.rappytv.toolwarn.ToolwarnConfig;
import com.rappytv.toolwarn.api.IToolwarnSounds;
import com.rappytv.toolwarn.api.WarnSound;
import com.rappytv.toolwarn.core.generated.DefaultReferenceStorage;
import com.rappytv.toolwarn.listener.ConfigMigrationListener;
import com.rappytv.toolwarn.listener.GameTickListener;
import com.rappytv.toolwarn.util.DefaultToolwarnSounds;
import net.labymod.api.Laby;
import net.labymod.api.addon.LabyAddon;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.component.format.TextDecoration;
import net.labymod.api.client.resources.ResourceLocation;
import net.labymod.api.models.addon.annotation.AddonMain;
import net.labymod.api.revision.Revision;
import net.labymod.api.revision.SimpleRevision;
import net.labymod.api.util.version.SemanticVersion;

@AddonMain
public class ToolwarnAddon
extends LabyAddon<ToolwarnConfig> {
    public static Component prefix = ((TextComponent)((TextComponent)Component.empty().append(Component.text((String)"TBW", (TextColor)NamedTextColor.RED).decorate(TextDecoration.BOLD))).append((Component)Component.space())).append((Component)Component.text((String)"\u00bb ", (TextColor)NamedTextColor.DARK_GRAY));
    private static ToolwarnAddon instance;
    private IToolwarnSounds sounds;

    public static ToolwarnAddon getInstance() {
        return instance;
    }

    protected void preConfigurationLoad() {
        Laby.references().revisionRegistry().register((Revision)new SimpleRevision("toolwarn", new SemanticVersion("1.3.4"), "2024-01-26"));
        Laby.references().revisionRegistry().register((Revision)new SimpleRevision("toolwarn", new SemanticVersion("1.4.0"), "2024-03-14"));
        this.registerListener(new ConfigMigrationListener());
    }

    protected void enable() {
        instance = this;
        this.registerSettingCategory();
        ((ToolwarnConfig)this.configuration()).createDefaultTools();
        this.sounds = ((DefaultReferenceStorage)this.referenceStorageAccessor()).getIToolwarnSounds();
        if (this.sounds == null) {
            this.sounds = new DefaultToolwarnSounds();
        }
        this.registerListener(new GameTickListener(this));
    }

    public ResourceLocation getWarnSound(WarnSound sound) {
        return switch (sound) {
            default -> throw new MatchException(null, null);
            case WarnSound.NONE -> null;
            case WarnSound.PLING -> this.sounds.getPlingSound();
            case WarnSound.LEVEL_UP -> this.sounds.getLevelUpSound();
            case WarnSound.GLASS_BREAK -> this.sounds.getGlassBreakSound();
            case WarnSound.ANVIL_USE -> this.sounds.getAnvilUseSound();
        };
    }

    protected Class<? extends ToolwarnConfig> configurationClass() {
        return ToolwarnConfig.class;
    }
}

