/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.toolwarn.ui.activities;

import com.rappytv.toolwarn.ToolwarnAddon;
import com.rappytv.toolwarn.ToolwarnConfig;
import com.rappytv.toolwarn.api.WarnSound;
import com.rappytv.toolwarn.api.WarnTool;
import com.rappytv.toolwarn.ui.widgets.ToolWidget;
import java.util.ArrayList;
import java.util.List;
import net.labymod.api.client.gui.mouse.MutableMouse;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.activity.Activity;
import net.labymod.api.client.gui.screen.activity.AutoActivity;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.activity.Links;
import net.labymod.api.client.gui.screen.key.InputType;
import net.labymod.api.client.gui.screen.key.Key;
import net.labymod.api.client.gui.screen.key.MouseButton;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.DivWidget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.Document;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.CheckBoxWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.SliderWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.dropdown.DropdownWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.ScrollWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.VerticalListWidget;

@Links(value={@Link(value="manage.lss"), @Link(value="config.lss")})
@AutoActivity
public class ToolConfigActivity
extends Activity {
    private final ToolwarnAddon addon = ToolwarnAddon.getInstance();
    private final VerticalListWidget<ToolWidget> toolList;
    private final List<ToolWidget> toolWidgets = new ArrayList<ToolWidget>();
    private ToolWidget selectedTool;
    private ButtonWidget removeButton;
    private ButtonWidget editButton;
    private FlexibleContentWidget inputWidget;
    private Action action;

    public ToolConfigActivity() {
        ((ToolwarnConfig)this.addon.configuration()).getTools().forEach(tool -> this.toolWidgets.add(new ToolWidget((WarnTool)tool)));
        this.toolList = (VerticalListWidget)new VerticalListWidget().addId("tool-list");
        this.toolList.setSelectCallback(nameTagWidget -> {
            ToolWidget selectedNameTag = (ToolWidget)((Object)((Object)this.toolList.listSession().getSelectedEntry()));
            if (selectedNameTag == null || selectedNameTag.getTool() != nameTagWidget.getTool()) {
                this.editButton.setEnabled(true);
                this.removeButton.setEnabled(true);
            }
        });
        this.toolList.setDoubleClickCallback(nameTagWidget -> this.setAction(Action.EDIT));
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        FlexibleContentWidget container = (FlexibleContentWidget)new FlexibleContentWidget().addId("tool-container");
        for (ToolWidget nameTagWidget : this.toolWidgets) {
            this.toolList.addChild((Widget)nameTagWidget);
        }
        this.selectedTool = (ToolWidget)((Object)this.toolList.listSession().getSelectedEntry());
        HorizontalListWidget buttons = (HorizontalListWidget)new HorizontalListWidget().addId("overview-button-menu");
        this.editButton = ButtonWidget.i18n((String)"labymod.ui.button.edit", () -> this.setAction(Action.EDIT));
        this.editButton.setEnabled(this.selectedTool != null);
        this.removeButton = ButtonWidget.i18n((String)"labymod.ui.button.remove", () -> this.setAction(Action.REMOVE));
        this.removeButton.setEnabled(this.selectedTool != null);
        buttons.addEntry((Widget)ButtonWidget.i18n((String)"labymod.ui.button.add", () -> this.setAction(Action.ADD)));
        buttons.addEntry((Widget)this.editButton);
        buttons.addEntry((Widget)this.removeButton);
        container.addFlexibleContent((Widget)new ScrollWidget(this.toolList));
        container.addContent((Widget)buttons);
        ((Document)this.document()).addChild((Widget)container);
        if (this.action == null) {
            return;
        }
        DivWidget overlayWidget = switch (this.action.ordinal()) {
            case 1 -> this.initializeManageContainer(this.selectedTool);
            case 2 -> this.initializeRemoveContainer(this.selectedTool);
            default -> {
                ToolWidget newCustomNameTag = new ToolWidget(new WarnTool());
                yield this.initializeManageContainer(newCustomNameTag);
            }
        };
        DivWidget manageContainer = (DivWidget)new DivWidget().addId("manage-container");
        manageContainer.addChild((Widget)overlayWidget);
        ((Document)this.document()).addChild((Widget)manageContainer);
    }

    private FlexibleContentWidget initializeRemoveContainer(ToolWidget toolWidget) {
        this.inputWidget = (FlexibleContentWidget)new FlexibleContentWidget().addId("remove-container");
        ComponentWidget confirmationWidget = (ComponentWidget)ComponentWidget.i18n((String)"toolwarn.gui.remove").addId("remove-confirmation");
        ToolWidget previewWidget = new ToolWidget(toolWidget.getTool());
        previewWidget.addId("remove-preview");
        HorizontalListWidget menu = new HorizontalListWidget();
        menu.addId("remove-button-menu");
        menu.addEntry((Widget)ButtonWidget.i18n((String)"labymod.ui.button.remove", () -> {
            ((ToolwarnConfig)this.addon.configuration()).getTools().remove(toolWidget.getTool());
            this.toolWidgets.remove((Object)toolWidget);
            this.toolList.listSession().setSelectedEntry(null);
            this.setAction(null);
        }));
        menu.addEntry((Widget)ButtonWidget.i18n((String)"labymod.ui.button.cancel", () -> this.setAction(null)));
        this.inputWidget.addContent((Widget)confirmationWidget);
        this.inputWidget.addContent((Widget)previewWidget);
        this.inputWidget.addContent((Widget)menu);
        return this.inputWidget;
    }

    private DivWidget initializeManageContainer(ToolWidget toolWidget) {
        ButtonWidget doneButton = ButtonWidget.i18n((String)"labymod.ui.button.done");
        DivWidget inputContainer = (DivWidget)new DivWidget().addId("input-container");
        DivWidget typeDiv = (DivWidget)new DivWidget().addId("type-div");
        ComponentWidget typeText = (ComponentWidget)ComponentWidget.i18n((String)"toolwarn.gui.type").addId("type-name");
        DropdownWidget typeDropdown = (DropdownWidget)new DropdownWidget().addId("type-dropdown");
        for (WarnTool.Type type : WarnTool.Type.values()) {
            if (type == WarnTool.Type.NONE) continue;
            typeDropdown.add((Object)type);
        }
        typeDropdown.setTranslationKeyPrefix("toolwarn.gui.dropdown.type");
        typeDropdown.setSelected((Object)toolWidget.getTool().getType());
        typeDiv.addChild((Widget)typeText);
        typeDiv.addChild((Widget)typeDropdown);
        ComponentWidget sliderText = (ComponentWidget)ComponentWidget.i18n((String)"toolwarn.gui.slider").addId("slider-name");
        SliderWidget warnSlider = (SliderWidget)new SliderWidget().addId("warn-slider");
        warnSlider.range(1.0f, 25.0f);
        warnSlider.setValue((double)toolWidget.getTool().getWarnAt());
        DivWidget soundDiv = (DivWidget)new DivWidget().addId("dropdown-div");
        DivWidget lastSoundDiv = (DivWidget)new DivWidget().addId("dropdown-div");
        ComponentWidget soundText = (ComponentWidget)ComponentWidget.i18n((String)"toolwarn.gui.dropdown.warnSound").addId("dropdown-name");
        DropdownWidget soundDropdown = (DropdownWidget)new DropdownWidget().addId("dropdown-item");
        soundDropdown.setTranslationKeyPrefix("toolwarn.gui.dropdown.sound");
        ComponentWidget lastSoundText = (ComponentWidget)ComponentWidget.i18n((String)"toolwarn.gui.dropdown.lastSound").addId("dropdown-name");
        DropdownWidget lastSoundDropdown = (DropdownWidget)new DropdownWidget().addId("dropdown-item");
        lastSoundDropdown.setTranslationKeyPrefix("toolwarn.gui.dropdown.sound");
        soundDiv.addChild((Widget)soundText);
        soundDiv.addChild((Widget)soundDropdown);
        lastSoundDiv.addChild((Widget)lastSoundText);
        lastSoundDiv.addChild((Widget)lastSoundDropdown);
        for (WarnSound sound : WarnSound.values()) {
            soundDropdown.add((Object)sound);
            lastSoundDropdown.add((Object)sound);
        }
        soundDropdown.setSelected((Object)toolWidget.getTool().getSound());
        lastSoundDropdown.setSelected((Object)toolWidget.getTool().getLastSound());
        DivWidget openChatDiv = (DivWidget)new DivWidget().addId("checkbox-div");
        DivWidget lastHitDiv = (DivWidget)new DivWidget().addId("checkbox-div");
        ComponentWidget openChatText = (ComponentWidget)ComponentWidget.i18n((String)"toolwarn.gui.checkbox.openChat").addId("checkbox-name");
        CheckBoxWidget openChatCheck = (CheckBoxWidget)new CheckBoxWidget().addId("checkbox-item");
        openChatCheck.setState(toolWidget.getTool().openChat() ? CheckBoxWidget.State.CHECKED : CheckBoxWidget.State.UNCHECKED);
        ComponentWidget lastHitText = (ComponentWidget)ComponentWidget.i18n((String)"toolwarn.gui.checkbox.lastHit").addId("checkbox-name");
        CheckBoxWidget lastHitCheck = (CheckBoxWidget)new CheckBoxWidget().addId("checkbox-item");
        lastHitCheck.setState(toolWidget.getTool().lastHitWarn() ? CheckBoxWidget.State.CHECKED : CheckBoxWidget.State.UNCHECKED);
        openChatDiv.addChild((Widget)openChatText);
        openChatDiv.addChild((Widget)openChatCheck);
        lastHitDiv.addChild((Widget)lastHitText);
        lastHitDiv.addChild((Widget)lastHitCheck);
        this.inputWidget = new FlexibleContentWidget();
        this.inputWidget.addId("input-list");
        HorizontalListWidget dropdownList = (HorizontalListWidget)new HorizontalListWidget().addId("dropdown-list");
        dropdownList.addEntry((Widget)soundDiv);
        dropdownList.addEntry((Widget)lastSoundDiv);
        HorizontalListWidget checkBoxList = (HorizontalListWidget)new HorizontalListWidget().addId("checkbox-list");
        checkBoxList.addEntry((Widget)openChatDiv);
        checkBoxList.addEntry((Widget)lastHitDiv);
        this.inputWidget.addContent((Widget)typeDiv);
        this.inputWidget.addContent((Widget)sliderText);
        this.inputWidget.addContent((Widget)warnSlider);
        this.inputWidget.addContent((Widget)dropdownList);
        this.inputWidget.addContent((Widget)checkBoxList);
        HorizontalListWidget buttonList = (HorizontalListWidget)new HorizontalListWidget().addId("edit-button-menu");
        doneButton.setEnabled(true);
        doneButton.setPressable(() -> {
            if (!this.toolWidgets.contains((Object)toolWidget)) {
                this.toolWidgets.add(toolWidget);
                this.toolList.listSession().setSelectedEntry((Object)toolWidget);
            }
            WarnTool tool = toolWidget.getTool();
            tool.setType((WarnTool.Type)((Object)((Object)typeDropdown.getSelected())));
            tool.setWarnAt((int)warnSlider.getValue());
            tool.setSound((WarnSound)((Object)((Object)soundDropdown.getSelected())));
            tool.setLastSound((WarnSound)((Object)((Object)lastSoundDropdown.getSelected())));
            tool.setOpenChat(openChatCheck.state() == CheckBoxWidget.State.CHECKED);
            tool.setLastHitWarn(lastHitCheck.state() == CheckBoxWidget.State.CHECKED);
            ((ToolwarnConfig)this.addon.configuration()).getTools().remove(toolWidget.getTool());
            ((ToolwarnConfig)this.addon.configuration()).getTools().add(tool);
            ((ToolwarnConfig)this.addon.configuration()).removeInvalidTools();
            toolWidget.setTool(tool);
            this.setAction(null);
        });
        buttonList.addEntry((Widget)doneButton);
        buttonList.addEntry((Widget)ButtonWidget.i18n((String)"labymod.ui.button.cancel", () -> this.setAction(null)));
        this.inputWidget.addContent((Widget)buttonList);
        inputContainer.addChild((Widget)this.inputWidget);
        return inputContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mouseClicked(MutableMouse mouse, MouseButton mouseButton) {
        block3: {
            boolean bl;
            try {
                if (this.action == null) break block3;
                bl = this.inputWidget.mouseClicked(mouse, mouseButton);
            }
            catch (Throwable throwable) {
                this.selectedTool = (ToolWidget)((Object)this.toolList.listSession().getSelectedEntry());
                this.removeButton.setEnabled(this.selectedTool != null);
                this.editButton.setEnabled(this.selectedTool != null);
                throw throwable;
            }
            this.selectedTool = (ToolWidget)((Object)this.toolList.listSession().getSelectedEntry());
            this.removeButton.setEnabled(this.selectedTool != null);
            this.editButton.setEnabled(this.selectedTool != null);
            return bl;
        }
        boolean bl = super.mouseClicked(mouse, mouseButton);
        this.selectedTool = (ToolWidget)((Object)this.toolList.listSession().getSelectedEntry());
        this.removeButton.setEnabled(this.selectedTool != null);
        this.editButton.setEnabled(this.selectedTool != null);
        return bl;
    }

    public boolean keyPressed(Key key, InputType type) {
        if (key.getId() == 256 && this.action != null) {
            this.setAction(null);
            return true;
        }
        return super.keyPressed(key, type);
    }

    private void setAction(Action action) {
        this.action = action;
        this.reload();
    }

    private static enum Action {
        ADD,
        EDIT,
        REMOVE;

    }
}

