/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.toolwarn.ui.widgets;

import com.rappytv.toolwarn.api.WarnTool;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.widget.SimpleWidget;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;

@AutoWidget
public class ToolWidget
extends SimpleWidget {
    private static final Component enabled = Component.text((String)"\u2714", (TextColor)NamedTextColor.GREEN);
    private static final Component disabled = Component.text((String)"\u2718", (TextColor)NamedTextColor.RED);
    private WarnTool tool;

    public ToolWidget(WarnTool tool) {
        this.tool = tool;
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        IconWidget iconWidget = (IconWidget)new IconWidget(this.tool.getType().getIcon()).addId("tool-icon");
        ComponentWidget nameWidget = (ComponentWidget)ComponentWidget.i18n((String)("toolwarn.gui.dropdown.type." + this.tool.getType().name().toLowerCase())).addId("name-component");
        ComponentWidget meta = (ComponentWidget)ComponentWidget.component((Component)Component.translatable((String)"toolwarn.gui.meta", (Component[])new Component[]{Component.text((Object)this.tool.getWarnAt()), this.tool.openChat() ? enabled : disabled, this.tool.lastHitWarn() ? enabled : disabled})).addId("meta-component");
        this.addChild((Widget)iconWidget);
        this.addChild((Widget)nameWidget);
        this.addChild((Widget)meta);
    }

    public WarnTool getTool() {
        return this.tool;
    }

    public void setTool(WarnTool tool) {
        this.tool = tool;
    }
}

