/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.toolwarn.listener;

import com.rappytv.toolwarn.ToolwarnAddon;
import com.rappytv.toolwarn.ToolwarnConfig;
import com.rappytv.toolwarn.api.WarnSound;
import com.rappytv.toolwarn.api.WarnTool;
import java.util.ArrayList;
import java.util.List;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.entity.player.ClientPlayer;
import net.labymod.api.client.entity.player.GameMode;
import net.labymod.api.client.world.item.ItemStack;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.client.lifecycle.GameTickEvent;

public class GameTickListener {
    private final ToolwarnAddon addon;
    private final ToolwarnConfig config;
    private static final List<ItemStack> warns = new ArrayList<ItemStack>();

    public GameTickListener(ToolwarnAddon addon) {
        this.addon = addon;
        this.config = (ToolwarnConfig)addon.configuration();
    }

    @Subscribe
    public void onTick(GameTickEvent event) {
        if (!((Boolean)((ToolwarnConfig)this.addon.configuration()).enabled().get()).booleanValue()) {
            return;
        }
        ClientPlayer player = Laby.labyAPI().minecraft().getClientPlayer();
        if (player == null) {
            return;
        }
        ItemStack itemStack = player.getMainHandItemStack();
        if (itemStack == null) {
            return;
        }
        if (itemStack.getMaximumDamage() == 0) {
            return;
        }
        if (player.gameMode() != GameMode.SURVIVAL && player.gameMode() != GameMode.ADVENTURE) {
            return;
        }
        this.checkForWarn(itemStack, WarnTool.Type.getByItem(itemStack));
    }

    private void checkForWarn(ItemStack itemStack, WarnTool.Type type) {
        if (type == WarnTool.Type.NONE) {
            return;
        }
        if (Laby.labyAPI().minecraft().minecraftWindow().isScreenOpened()) {
            return;
        }
        int itemUsedInt = itemStack.getMaximumDamage() - itemStack.getCurrentDamageValue();
        for (WarnTool tool : this.config.getTools()) {
            if (tool.getType() != type) continue;
            int itemWarnInt = tool.getWarnAt() * itemStack.getMaximumDamage() / 100;
            if (itemUsedInt <= itemWarnInt) {
                if (warns.contains(itemStack)) continue;
                if (tool.openChat()) {
                    Laby.labyAPI().minecraft().openChat("");
                }
                Laby.references().chatExecutor().displayClientMessage(((TextComponent)Component.empty().append(ToolwarnAddon.prefix)).append((Component)Component.translatable((String)"toolwarn.messages.warning", (TextColor)NamedTextColor.RED, (Component[])new Component[]{Component.text((Object)tool.getWarnAt())})));
                warns.add(itemStack);
                if (tool.getSound() == WarnSound.NONE) continue;
                Laby.labyAPI().minecraft().sounds().playSound(this.addon.getWarnSound(tool.getSound()), 1.0f, 1.0f);
                continue;
            }
            if (tool.lastHitWarn() && itemUsedInt <= 1) {
                if (warns.contains(itemStack)) continue;
                if (tool.openChat()) {
                    Laby.labyAPI().minecraft().openChat("");
                }
                Laby.references().chatExecutor().displayClientMessage(((TextComponent)Component.empty().append(ToolwarnAddon.prefix)).append((Component)Component.translatable((String)"toolwarn.messages.lastHit", (TextColor)NamedTextColor.RED)));
                warns.add(itemStack);
                if (tool.getLastSound() == WarnSound.NONE) continue;
                Laby.labyAPI().minecraft().sounds().playSound(this.addon.getWarnSound(tool.getLastSound()), 1.0f, 1.0f);
                continue;
            }
            warns.remove(itemStack);
        }
    }
}

