/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.audio.device;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Singleton;
import net.labymod.addons.voicechat.api.audio.device.AudioInterface;
import net.labymod.addons.voicechat.api.audio.device.DeviceController;
import net.labymod.addons.voicechat.api.audio.device.DeviceInformation;
import net.labymod.addons.voicechat.api.audio.device.exception.DeviceException;
import net.labymod.addons.voicechat.api.audio.device.io.InputDevice;
import net.labymod.addons.voicechat.api.audio.device.io.OutputDevice;
import net.labymod.addons.voicechat.api.audio.device.util.ChannelType;
import net.labymod.addons.voicechat.api.audio.device.util.DeviceType;
import net.labymod.addons.voicechat.api.audio.device.util.Format;
import net.labymod.addons.voicechat.api.audio.noise.NoiseFilterFactory;
import net.labymod.addons.voicechat.api.audio.opus.OpusFactory;
import net.labymod.addons.voicechat.api.configuration.VoiceChatConfiguration;
import net.labymod.addons.voicechat.core.VoiceChatAddon;
import net.labymod.addons.voicechat.core.audio.device.task.io.InputAudioTask;
import net.labymod.addons.voicechat.core.audio.device.task.io.OutputAudioTask;
import net.labymod.addons.voicechat.core.generated.DefaultReferenceStorage;
import net.labymod.addons.voicechat.javaxsound.JavaxAudioInterface;
import net.labymod.addons.voicechat.openal.OpenALAudioInterface;
import net.labymod.api.Laby;
import net.labymod.api.event.EventBus;
import net.labymod.api.models.Implements;
import net.labymod.api.util.ThreadSafe;
import net.labymod.api.util.logging.Logging;
import org.jetbrains.annotations.Nullable;

@Singleton
@Implements(value=DeviceController.class)
public class DefaultDeviceController
implements DeviceController {
    public static final int SAMPLE_RATE = 48000;
    public static final int BUFFER_SIZE = 960;
    public static final int INPUT_DEVICE_DELAY = 250;
    public static final int OUTPUT_DEVICE_DELAY = 50;
    private final Logging logging = Logging.getLogger();
    private final Collection<AudioInterface> audioInterfaces = new ArrayList<AudioInterface>();
    private final Format inputFormat;
    private final Format outputFormat;
    private final InputAudioTask inputAudioTask;
    private final OutputAudioTask outputAudioTask;
    private InputDevice selectedInputDevice;
    private OutputDevice selectedOutputDevice;

    public DefaultDeviceController() {
        EventBus eventBus = Laby.labyAPI().eventBus();
        DefaultReferenceStorage references = VoiceChatAddon.INSTANCE.referenceStorage();
        VoiceChatConfiguration configuration = (VoiceChatConfiguration)VoiceChatAddon.INSTANCE.configuration();
        this.inputFormat = new Format.Builder().sampleRate(48000).channels(ChannelType.MONO).build();
        this.outputFormat = new Format.Builder().sampleRate(48000).channels(ChannelType.STEREO).build();
        OpusFactory opus = references.opusFactory();
        try {
            opus.initialize();
        }
        catch (Throwable e) {
            this.logging.error((CharSequence)"Failed to initialize Opus", e);
        }
        NoiseFilterFactory noise = references.noiseFilterFactory();
        try {
            noise.initialize();
        }
        catch (Throwable e) {
            this.logging.error((CharSequence)"Failed to initialize RNNoise", e);
        }
        this.inputAudioTask = new InputAudioTask(this, references, 960);
        this.outputAudioTask = new OutputAudioTask(this, references, 960);
        eventBus.registerListener((Object)this.inputAudioTask);
        eventBus.registerListener((Object)this.outputAudioTask);
        this.registerDefaults();
        this.updateDevices();
        this.setSelectedDeviceByIdentifierOrDefault(DeviceType.INPUT, (String)configuration.inputDeviceName().get());
        this.setSelectedDeviceByIdentifierOrDefault(DeviceType.OUTPUT, (String)configuration.outputDeviceName().get());
    }

    public void registerDefaults() {
        this.audioInterfaces.clear();
        VoiceChatConfiguration configuration = (VoiceChatConfiguration)VoiceChatAddon.INSTANCE.configuration();
        if (((Boolean)configuration.alternativeAudioInterfaces().get()).booleanValue()) {
            this.registerAudioInterface(new JavaxAudioInterface());
        }
        this.registerAudioInterface(new OpenALAudioInterface());
    }

    @Override
    public void registerAudioInterface(AudioInterface audioInterface) {
        this.audioInterfaces.add(audioInterface);
    }

    @Override
    public void updateInputDevices() {
        for (AudioInterface audioInterface : this.audioInterfaces) {
            audioInterface.updateInputDevices(this.inputFormat);
        }
        if (this.selectedInputDevice != null && !this.isInputDeviceRunning()) {
            try {
                this.openInputDevice(this.selectedInputDevice);
            }
            catch (DeviceException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void updateOutputDevices() {
        for (AudioInterface audioInterface : this.audioInterfaces) {
            audioInterface.updateOutputDevices(this.outputFormat);
        }
        if (this.selectedOutputDevice != null && !this.isOutputDeviceRunning()) {
            try {
                this.openOutputDevice(this.selectedOutputDevice);
            }
            catch (DeviceException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setSelectedInputDevice(InputDevice device) throws IOException {
        if (this.selectedInputDevice != null && this.selectedInputDevice.information().equals(device.information())) {
            return;
        }
        if (this.selectedInputDevice != null && this.selectedInputDevice.isOpen()) {
            InputDevice deviceToClose = this.selectedInputDevice;
            this.inputAudioTask.scheduleTask(() -> {
                try {
                    deviceToClose.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        this.selectedInputDevice = device;
        this.openInputDevice(device);
    }

    @Override
    public void setSelectedOutputDevice(OutputDevice device) throws IOException {
        if (this.selectedOutputDevice != null && this.selectedOutputDevice.information().equals(device.information())) {
            return;
        }
        if (this.selectedOutputDevice != null && this.selectedOutputDevice.isOpen()) {
            OutputDevice deviceToClose = this.selectedOutputDevice;
            this.outputAudioTask.scheduleTask(() -> {
                try {
                    deviceToClose.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        this.selectedOutputDevice = device;
        this.openOutputDevice(device);
    }

    @Override
    public Collection<DeviceInformation> getDevices(DeviceType type) {
        ArrayList<DeviceInformation> devices = new ArrayList<DeviceInformation>();
        for (AudioInterface audioInterface : this.audioInterfaces) {
            devices.addAll(audioInterface.getDevices(type));
        }
        return devices;
    }

    @Override
    @Nullable
    public InputDevice getSelectedInputDevice() {
        return this.selectedInputDevice;
    }

    @Override
    @Nullable
    public OutputDevice getSelectedOutputDevice() {
        return this.selectedOutputDevice;
    }

    @Override
    public DeviceInformation getDeviceByIdentifier(DeviceType type, String identifier) {
        String[] segments = identifier.split(":", 2);
        if (segments.length != 2) {
            for (AudioInterface audioInterface : this.audioInterfaces) {
                for (DeviceInformation device : audioInterface.getDevices(type)) {
                    if (!device.getIdentifier().toString().equals(identifier)) continue;
                    return device;
                }
            }
            return null;
        }
        String interfaceIdentifier = segments[0];
        String deviceIdentifier = segments[1];
        AudioInterface audioInterface = this.getAudioInterface(interfaceIdentifier);
        if (audioInterface == null) {
            return null;
        }
        for (DeviceInformation device : audioInterface.getDevices(type)) {
            if (!device.getIdentifier().getDeviceId().equals(deviceIdentifier)) continue;
            return device;
        }
        return null;
    }

    @Override
    public DeviceInformation getDefaultInputDevice() {
        for (AudioInterface audioInterface : this.audioInterfaces) {
            DeviceInformation device = audioInterface.getDefaultInputDevice(this.inputFormat);
            if (device == null) continue;
            return device;
        }
        return null;
    }

    @Override
    public DeviceInformation getDefaultOutputDevice() {
        for (AudioInterface audioInterface : this.audioInterfaces) {
            DeviceInformation device = audioInterface.getDefaultOutputDevice(this.outputFormat);
            if (device == null) continue;
            return device;
        }
        return null;
    }

    @Override
    @Nullable
    public AudioInterface getAudioInterface(String identifier) {
        for (AudioInterface audioInterface : this.audioInterfaces) {
            if (!audioInterface.getIdentifier().equals(identifier)) continue;
            return audioInterface;
        }
        return null;
    }

    @Override
    public Collection<AudioInterface> getAudioInterfaces() {
        return this.audioInterfaces;
    }

    @Override
    public boolean isInputDeviceRunning() {
        return this.selectedInputDevice != null && this.selectedInputDevice.isOpen() && this.inputAudioTask.isRunning();
    }

    @Override
    public boolean isOutputDeviceRunning() {
        return this.selectedOutputDevice != null && this.selectedOutputDevice.isOpen() && this.outputAudioTask.isRunning();
    }

    private void openInputDevice(InputDevice device) throws DeviceException {
        if (!device.isOpen()) {
            int bufferSize = this.inputFormat.getBufferSizeForMs(250);
            device.open(this.inputFormat, bufferSize);
        }
        ThreadSafe.executeOnRenderThread(this.inputAudioTask::start);
    }

    private void openOutputDevice(OutputDevice device) throws DeviceException {
        if (!device.isOpen()) {
            int bufferSize = this.inputFormat.getBufferSizeForMs(50);
            device.open(this.outputFormat, bufferSize);
        }
        ThreadSafe.executeOnRenderThread(this.outputAudioTask::start);
    }

    private void setSelectedDeviceByIdentifierOrDefault(DeviceType type, String identifier) {
        try {
            this.setSelectedDeviceByIdentifier(type, identifier);
        }
        catch (Throwable e) {
            this.logging.error((CharSequence)("Could not find " + type.name() + " device with identifier " + identifier), new Object[0]);
            try {
                DeviceInformation defaultDevice = this.getDefaultDevice(type);
                if (defaultDevice != null) {
                    this.logging.info((CharSequence)("Using default " + type.name() + " device " + defaultDevice.getDisplayName()), new Object[0]);
                    this.setSelectedDevice(defaultDevice.create());
                }
            }
            catch (Throwable ex) {
                this.logging.error((CharSequence)("Could not set default " + type.name() + " device"), ex);
            }
        }
    }
}

