/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.audio.device.task.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import net.labymod.addons.voicechat.api.VoiceChat;
import net.labymod.addons.voicechat.api.audio.device.DeviceController;
import net.labymod.addons.voicechat.api.audio.device.io.OutputDevice;
import net.labymod.addons.voicechat.api.audio.device.io.OutputDevice3D;
import net.labymod.addons.voicechat.api.audio.device.util.ChannelType;
import net.labymod.addons.voicechat.api.audio.device.util.DeviceType;
import net.labymod.addons.voicechat.api.audio.stream.AudioStreamRegistry;
import net.labymod.addons.voicechat.api.audio.stream.user.AudioStream;
import net.labymod.addons.voicechat.api.audio.stream.user.UserAudioStream;
import net.labymod.addons.voicechat.api.audio.stream.user.player.PlayerAudioStream;
import net.labymod.addons.voicechat.api.audio.stream.user.player.effect.AudioPostProcessor;
import net.labymod.addons.voicechat.api.channel.ChannelController;
import net.labymod.addons.voicechat.api.configuration.VoiceChatConfiguration;
import net.labymod.addons.voicechat.api.generated.ReferenceStorage;
import net.labymod.addons.voicechat.core.audio.device.task.AbstractAudioTask;
import net.labymod.api.Laby;
import net.labymod.api.client.Minecraft;
import net.labymod.api.client.world.MinecraftCamera;
import net.labymod.api.util.math.vector.DoubleVector3;

public class OutputAudioTask
extends AbstractAudioTask {
    private final DeviceController deviceController;
    private final AudioStreamRegistry streamRegistry;
    private final ChannelController channelController;
    private final VoiceChatConfiguration config;
    private final VoiceChat voiceChat;
    private final Minecraft minecraft;
    private final int bufferSize;
    private short[] buffer;

    public OutputAudioTask(DeviceController deviceController, ReferenceStorage references, int bufferSize) {
        super(DeviceType.OUTPUT);
        this.deviceController = deviceController;
        this.streamRegistry = references.audioStreamRegistry();
        this.channelController = references.channelController();
        this.config = references.voiceChat().configuration();
        this.voiceChat = references.voiceChat();
        this.minecraft = Laby.labyAPI().minecraft();
        this.bufferSize = bufferSize;
    }

    @Override
    protected void process() {
        AudioStream stream;
        Map<UUID, AudioStream> streams = this.streamRegistry.getStreams();
        if (!((Boolean)this.config.enabled().get()).booleanValue() || streams.isEmpty()) {
            return;
        }
        OutputDevice device = this.deviceController.getSelectedOutputDevice();
        if (device == null || !device.isOpen()) {
            return;
        }
        if (!(device instanceof OutputDevice3D)) {
            return;
        }
        OutputDevice3D device3D = (OutputDevice3D)device;
        if (!device.isActive()) {
            device.start();
        }
        MinecraftCamera camera = this.minecraft.getCamera();
        if (!this.voiceChat.isTestingMicrophone() && this.channelController.isInProximity() && camera == null) {
            return;
        }
        this.prepare(device3D, camera);
        device3D.setReferenceDistance((float)((Integer)this.config.surroundRange().get()).intValue() / 2.0f);
        device3D.setRolloffFactor(3.4f);
        device3D.setMaxDistance(100.0f);
        int channels = device.information().getFormat().getChannels();
        if (this.buffer == null || this.buffer.length != this.bufferSize * channels) {
            this.buffer = new short[this.bufferSize * channels];
        }
        for (Map.Entry<UUID, AudioStream> entry : streams.entrySet()) {
            UserAudioStream userStream;
            boolean isFromClient;
            stream = entry.getValue();
            stream.collect();
            int available = stream.available();
            if (available < this.bufferSize || !device3D.isSourceWriteable(stream.getId())) continue;
            stream.read(this.buffer, 0, this.bufferSize);
            boolean bl = isFromClient = stream instanceof UserAudioStream && (userStream = (UserAudioStream)stream).voiceUser().isClient();
            if (isFromClient && !this.voiceChat.isTestingMicrophone()) continue;
            AudioPostProcessor postProcessor = stream.getPostProcessor();
            postProcessor.process(this.buffer, 0, this.bufferSize);
            this.writeSource(device3D, stream);
        }
        for (Map.Entry<UUID, AudioStream> entry : streams.entrySet()) {
            stream = entry.getValue();
            UUID overlayId = new UUID(entry.getKey().getMostSignificantBits(), entry.getKey().getLeastSignificantBits() + 1L);
            AudioPostProcessor postProcessor = stream.getPostProcessor();
            if (!postProcessor.hasStereo() || postProcessor.canClose() || !device3D.isSourceWriteable(overlayId)) continue;
            Arrays.fill(this.buffer, (short)0);
            postProcessor.readStereoOverlay(this.buffer, 0, this.buffer.length);
            device3D.writeSource(overlayId, ChannelType.STEREO, this.buffer, 0, this.bufferSize * 2, stream.getVolume());
        }
        device3D.upload();
    }

    private void prepare(OutputDevice3D device, MinecraftCamera camera) {
        if (camera == null) {
            device.prepare(this.bufferSize);
        } else {
            device.prepare(camera.position(), camera.getYaw(), this.bufferSize);
        }
    }

    private void writeSource(OutputDevice3D device, AudioStream stream) {
        if (stream.isClosed()) {
            return;
        }
        double volume = stream.getVolume();
        UUID id = stream.getId();
        MinecraftCamera camera = this.minecraft.getCamera();
        if (camera == null || !(stream instanceof PlayerAudioStream)) {
            device.writeSource(id, ChannelType.MONO, this.buffer, 0, this.bufferSize, volume);
            return;
        }
        PlayerAudioStream player = (PlayerAudioStream)stream;
        DoubleVector3 position = player.position().toDoubleVector3();
        if (((Boolean)this.config.stereo().get()).booleanValue()) {
            device.writeSource(id, ChannelType.MONO, this.buffer, 0, this.bufferSize, volume, position);
        } else {
            float distance = position.distance(camera.position());
            DoubleVector3 cameraAbove = camera.position().copy().add(0.0, (double)distance, 0.0);
            device.writeSource(id, ChannelType.MONO, this.buffer, 0, this.bufferSize, volume, cameraAbove);
        }
    }

    @Override
    public void close() {
        super.close();
        OutputDevice device = this.deviceController.getSelectedOutputDevice();
        if (device != null && device.isOpen()) {
            try {
                device.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public long getProcessIntervalMs() {
        OutputDevice device = this.deviceController.getSelectedOutputDevice();
        return device == null ? 500L : device.getProcessIntervalMs();
    }

    @Override
    public String getTaskName() {
        return "Speaker";
    }
}

