/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.audio.stream;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.labymod.addons.voicechat.api.VoiceChat;
import net.labymod.addons.voicechat.api.audio.device.DeviceController;
import net.labymod.addons.voicechat.api.audio.opus.OpusFactory;
import net.labymod.addons.voicechat.api.audio.stream.AudioStreamRegistry;
import net.labymod.addons.voicechat.api.audio.stream.AudioStreamState;
import net.labymod.addons.voicechat.api.audio.stream.user.AudioStream;
import net.labymod.addons.voicechat.api.audio.stream.user.UserAudioStream;
import net.labymod.addons.voicechat.api.channel.Channel;
import net.labymod.addons.voicechat.api.channel.ChannelController;
import net.labymod.addons.voicechat.api.channel.ChannelUser;
import net.labymod.addons.voicechat.api.client.VoiceConnector;
import net.labymod.addons.voicechat.api.client.user.VoiceUser;
import net.labymod.addons.voicechat.api.client.user.VoiceUserRegistry;
import net.labymod.addons.voicechat.api.configuration.VoiceChatConfiguration;
import net.labymod.addons.voicechat.api.event.stream.AudioStreamShutdownEvent;
import net.labymod.addons.voicechat.api.event.stream.AudioStreamStartEvent;
import net.labymod.addons.voicechat.core.VoiceChatAddon;
import net.labymod.addons.voicechat.core.audio.stream.user.AbstractAudioStream;
import net.labymod.addons.voicechat.core.audio.stream.user.DefaultUserAudioStream;
import net.labymod.addons.voicechat.core.audio.stream.user.player.DefaultPlayerAudioStream;
import net.labymod.api.Laby;
import net.labymod.api.client.Minecraft;
import net.labymod.api.client.entity.player.Player;
import net.labymod.api.event.Event;
import net.labymod.api.models.Implements;
import net.labymod.voice.protocol.util.properties.UserProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Implements(value=AudioStreamRegistry.class)
public class DefaultAudioStreamRegistry
implements AudioStreamRegistry {
    private final VoiceChat voiceChat;
    private final VoiceChatConfiguration config;
    private final OpusFactory opus;
    private final VoiceConnector connector;
    private final VoiceUserRegistry userRegistry;
    private final ChannelController channelController;
    private final Minecraft minecraft;
    private final Map<UUID, AudioStream> streams;

    @Inject
    public DefaultAudioStreamRegistry(VoiceChat voiceChat, VoiceConnector connector, VoiceUserRegistry userRegistry, ChannelController channelController, OpusFactory opus) {
        this.voiceChat = voiceChat;
        this.config = voiceChat.configuration();
        this.opus = opus;
        this.connector = connector;
        this.userRegistry = userRegistry;
        this.channelController = channelController;
        this.minecraft = Laby.labyAPI().minecraft();
        this.streams = new ConcurrentHashMap<UUID, AudioStream>();
    }

    @Override
    public void submit(UUID uniqueId, byte[] encodedData, long segmentNumber) {
        ChannelUser user;
        if (!((Boolean)this.config.enabled().get()).booleanValue()) {
            return;
        }
        if (this.channelController.isInCustomChannel() ? (user = this.channelController.getClientChannelUser()) == null || !user.canListen(true) : this.channelController.isOutputMuted()) {
            return;
        }
        AudioStream stream = this.getStream(uniqueId);
        if (stream == null) {
            boolean globalAudio;
            VoiceUser user2 = this.userRegistry.getOrCreate(uniqueId);
            boolean bl = globalAudio = !this.channelController.isInProximity() || this.voiceChat.isTestingMicrophone() || user2.hasGlobalAudio();
            if (globalAudio) {
                stream = this.createStream(user2);
            } else {
                Optional player = this.minecraft.clientWorld().getPlayer(uniqueId);
                if (player.isEmpty()) {
                    return;
                }
                stream = this.createProximityStream((Player)player.get(), user2);
            }
        }
        stream.queueEncodedData(encodedData, segmentNumber);
        ((AbstractAudioStream)stream).incrementRX(encodedData.length);
    }

    @Override
    public void shutdownStream(UUID uniqueId) {
        AudioStream stream = this.streams.remove(uniqueId);
        if (stream != null) {
            stream.close();
            VoiceUser user = this.userRegistry.getOrCreate(uniqueId);
            Laby.fireEvent((Event)new AudioStreamShutdownEvent(user, stream));
        }
    }

    @Override
    @NotNull
    public AudioStreamState getState(@NotNull UUID uniqueId, boolean voiceChannelContext) {
        AudioStream stream;
        ChannelUser channelUser;
        if (!this.connector.isConnected() || !this.connector.isAuthenticated()) {
            return AudioStreamState.NETWORK_ERROR;
        }
        VoiceUser voiceUser = this.userRegistry.get(uniqueId);
        if (voiceUser == null) {
            return AudioStreamState.NETWORK_ERROR;
        }
        float playerVolume = this.config.getVolumeOf(uniqueId);
        if (playerVolume == 0.0f) {
            return AudioStreamState.OUTPUT_DISABLED;
        }
        DeviceController deviceController = this.voiceChat.referenceStorage().deviceController();
        if (voiceUser.isClient()) {
            if (this.channelController.isOutputMuted()) {
                return AudioStreamState.OUTPUT_MUTED;
            }
            if (!deviceController.isInputDeviceRunning()) {
                return AudioStreamState.INPUT_DISABLED;
            }
            if (this.channelController.isInputMuted()) {
                return AudioStreamState.INPUT_MUTED;
            }
        }
        if ((channelUser = this.channelController.index().getChannelUserById(uniqueId)) != null) {
            Channel currentChannel;
            UserProperties properties = channelUser.properties();
            if (properties.isOutputDisabled()) {
                return AudioStreamState.OUTPUT_DISABLED;
            }
            if (properties.isOutputMuted()) {
                return AudioStreamState.OUTPUT_MUTED;
            }
            if (properties.isInputMuted()) {
                return AudioStreamState.INPUT_MUTED;
            }
            if (properties.isInputDisabled()) {
                return AudioStreamState.INPUT_DISABLED;
            }
            if (!(voiceChannelContext || (currentChannel = this.channelController.getCurrentChannel()) != null && currentChannel.users().getById(uniqueId) != null)) {
                return AudioStreamState.IN_ANOTHER_CHANNEL;
            }
        }
        if ((stream = this.getStream(uniqueId)) != null && stream.isTalking()) {
            return AudioStreamState.TALKING;
        }
        if (voiceUser.isMutedForClient()) {
            return AudioStreamState.INPUT_GLOBAL_MUTED;
        }
        if (!voiceChannelContext && !voiceUser.getChannelId().equals(this.channelController.getCurrentChannelId())) {
            return AudioStreamState.IN_ANOTHER_CHANNEL;
        }
        return AudioStreamState.NOT_TALKING;
    }

    @Override
    @NotNull
    public AudioStreamState getClientState(boolean voiceChannelContext) {
        return this.getState(VoiceChatAddon.getSessionId(), voiceChannelContext);
    }

    @Override
    public boolean hasStream(@NotNull UUID uniqueId) {
        return this.streams.containsKey(uniqueId);
    }

    @Override
    public AudioStream getStream(@NotNull UUID uniqueId) {
        return this.streams.get(uniqueId);
    }

    @Override
    @Nullable
    public AudioStream getClientStream() {
        return this.getStream(VoiceChatAddon.getSessionId());
    }

    @Override
    @NotNull
    public AudioStream createProximityStream(@NotNull Player player, @NotNull VoiceUser user) {
        DefaultPlayerAudioStream stream = new DefaultPlayerAudioStream(player, user, this.opus);
        this.initializeUserStream(stream);
        return stream;
    }

    @Override
    @NotNull
    public AudioStream createStream(@NotNull VoiceUser user) {
        DefaultUserAudioStream stream = new DefaultUserAudioStream(user, this.opus);
        this.initializeUserStream(stream);
        return stream;
    }

    @Override
    public Map<UUID, AudioStream> getStreams() {
        return this.streams;
    }

    @Override
    public void tick() {
        if (this.streams.isEmpty()) {
            return;
        }
        for (Map.Entry<UUID, AudioStream> entry : this.streams.entrySet()) {
            AudioStream stream = entry.getValue();
            stream.tick();
            if (!stream.canShutdown()) continue;
            this.shutdownStream(entry.getKey());
        }
    }

    @Override
    public void shutdownAllStreams() {
        for (UUID uniqueId : this.streams.keySet().toArray(new UUID[0])) {
            this.shutdownStream(uniqueId);
        }
    }

    private void initializeUserStream(UserAudioStream stream) {
        UUID uniqueId = stream.getUserId();
        stream.initialize();
        this.streams.put(uniqueId, stream);
        VoiceUser user = this.userRegistry.getOrCreate(uniqueId);
        Laby.fireEvent((Event)new AudioStreamStartEvent(user, stream));
    }
}

