/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.audio.stream.user;

import net.labymod.addons.voicechat.api.audio.stream.user.AudioFrame;

public class DefaultAudioFrame
implements AudioFrame {
    private final short[] buffer;
    private final long segmentNumber;
    private int read = 0;

    public DefaultAudioFrame(short[] buffer, long segmentNumber) {
        this.buffer = buffer;
        this.segmentNumber = segmentNumber;
    }

    @Override
    public int available() {
        return this.buffer.length - this.read;
    }

    @Override
    public void read(short[] out, int offset, int length) {
        int available = this.available();
        if (available < length) {
            throw new IllegalStateException("Not enough samples to read");
        }
        System.arraycopy(this.buffer, this.read, out, offset, length);
        this.read += length;
    }

    @Override
    public long getSegmentNumber() {
        return this.segmentNumber;
    }

    @Override
    public void reset() {
        this.read = 0;
    }

    @Override
    public short[] buffer() {
        return this.buffer;
    }
}

