/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.audio.stream.user.player.effect.filter;

import net.labymod.addons.voicechat.core.audio.stream.user.player.effect.AbstractAudioFilter;
import net.labymod.api.util.time.TimeUtil;

public class RogerBeepAudioFilter
extends AbstractAudioFilter {
    private static final long TIMEOUT = 500L;
    private static final long SAMPLE_RATE = 48000L;
    private static final Sequence[] SEQUENCE = new Sequence[]{new Sequence(775, 40), new Sequence(581, 40), new Sequence(689, 40), new Sequence(775, 40)};
    private boolean active;
    private long lastDataTime;
    private short volume;
    private int index;

    @Override
    public void preProcess(short[] samples, int offset, int length) {
        super.preProcess(samples, offset, length);
        this.lastDataTime = TimeUtil.getCurrentTimeMillis();
    }

    @Override
    public void readStereoOverlay(short[] out, int offset, int length) {
        super.readStereoOverlay(out, offset, length);
        long time = TimeUtil.getCurrentTimeMillis() - this.lastDataTime - 500L;
        if (time < 0L) {
            return;
        }
        long sum = 0L;
        for (Sequence sequence : SEQUENCE) {
            if (sum + (long)sequence.duration > time && sum < time) {
                this.writeBeep(out, length, 48000.0, sequence.frequency);
            }
            sum += (long)sequence.duration;
        }
    }

    private void writeBeep(short[] out, int length, double sampleRate, int frequency) {
        double period = sampleRate / (double)frequency;
        for (int i = 0; i < length / 2; ++i) {
            int index;
            short beep = (short)((double)this.volume * Math.sin(Math.PI * 2 * (double)this.index / period));
            int n = index = i * 2;
            out[n] = (short)(out[n] + beep);
            int n2 = index + 1;
            out[n2] = (short)(out[n2] + beep);
            ++this.index;
        }
    }

    @Override
    public boolean canClose() {
        long timePassedSinceLastData = TimeUtil.getCurrentTimeMillis() - this.lastDataTime;
        if (timePassedSinceLastData < 500L) {
            return false;
        }
        int sum = 0;
        for (Sequence sequence : SEQUENCE) {
            sum += sequence.duration;
        }
        return timePassedSinceLastData > 500L + (long)sum;
    }

    @Override
    public boolean hasStereo() {
        return true;
    }

    @Override
    public void reset() {
        this.index = 0;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setVolume(short volume) {
        this.volume = volume;
    }

    public boolean isPlayingBeep() {
        long timePassedSinceLastData = TimeUtil.getCurrentTimeMillis() - this.lastDataTime;
        return timePassedSinceLastData >= 500L;
    }

    private record Sequence(int frequency, int duration) {
    }
}

