/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.channel;

import java.util.Map;
import java.util.UUID;
import javax.inject.Singleton;
import net.labymod.addons.voicechat.api.audio.device.DeviceController;
import net.labymod.addons.voicechat.api.channel.Channel;
import net.labymod.addons.voicechat.api.channel.ChannelController;
import net.labymod.addons.voicechat.api.channel.ChannelIndex;
import net.labymod.addons.voicechat.api.channel.ChannelUser;
import net.labymod.addons.voicechat.api.client.VoiceConnector;
import net.labymod.addons.voicechat.api.client.transmitter.VoiceTransmitter;
import net.labymod.addons.voicechat.api.event.VoiceChatAuthenticatedEvent;
import net.labymod.addons.voicechat.api.event.VoiceChatDisconnectEvent;
import net.labymod.addons.voicechat.api.event.channel.ChannelHideEvent;
import net.labymod.addons.voicechat.api.event.channel.ChannelResetEvent;
import net.labymod.addons.voicechat.api.event.channel.ChannelShowEvent;
import net.labymod.addons.voicechat.api.event.channel.ChannelUpdateEvent;
import net.labymod.addons.voicechat.api.event.channel.ClientChannelSwitchEvent;
import net.labymod.addons.voicechat.api.event.channel.ClientPropertiesUpdateEvent;
import net.labymod.addons.voicechat.api.event.channel.UserHideEvent;
import net.labymod.addons.voicechat.api.event.channel.UserShowEvent;
import net.labymod.addons.voicechat.api.event.channel.UserUpdateEvent;
import net.labymod.addons.voicechat.api.event.device.DeviceStateChangedEvent;
import net.labymod.addons.voicechat.api.event.task.AudioTaskStateChangedEvent;
import net.labymod.addons.voicechat.core.VoiceChatAddon;
import net.labymod.addons.voicechat.core.channel.DefaultChannelIndex;
import net.labymod.addons.voicechat.core.channel.channel.AbstractChannel;
import net.labymod.addons.voicechat.core.channel.channel.CustomChannel;
import net.labymod.addons.voicechat.core.channel.channel.LobbyChannel;
import net.labymod.addons.voicechat.core.channel.channel.user.DefaultChannelUser;
import net.labymod.addons.voicechat.core.util.VoiceChatSounds;
import net.labymod.api.Laby;
import net.labymod.api.client.resources.ResourceLocation;
import net.labymod.api.client.resources.sound.MinecraftSounds;
import net.labymod.api.client.session.Session;
import net.labymod.api.event.Event;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.labymod.user.UserUpdateDataEvent;
import net.labymod.api.models.Implements;
import net.labymod.api.util.Debounce;
import net.labymod.api.util.logging.Logging;
import net.labymod.api.util.time.TimeUtil;
import net.labymod.voice.protocol.util.properties.ChannelProperties;
import net.labymod.voice.protocol.util.properties.UserProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Implements(value=ChannelController.class)
public class DefaultChannelController
implements ChannelController {
    @NotNull
    private final DefaultChannelIndex index = new DefaultChannelIndex();
    private final Logging logging = Logging.getLogger();
    @NotNull
    private UUID currentChannelId = LobbyChannel.ID;
    private boolean inputMuted;
    private boolean outputMuted;
    private boolean subscribed;
    private boolean prevIsProximity = true;
    private long timeLastReset;

    public DefaultChannelController() {
        Laby.labyAPI().eventBus().registerListener((Object)this);
    }

    public void onChannelShow(UUID channelId, ChannelProperties properties) {
        try {
            AbstractChannel channel = channelId.equals(LobbyChannel.ID) ? new LobbyChannel() : new CustomChannel(channelId);
            channel.update(properties);
            this.index.addChannel(channel);
            Laby.fireEvent((Event)new ChannelShowEvent(channel));
        }
        catch (Throwable t) {
            this.requestChannelReset(true, "Can't show channel with id " + String.valueOf(channelId) + " because of an error: " + t.getMessage());
        }
    }

    public void onChannelUpdate(UUID channelId, ChannelProperties properties) {
        AbstractChannel channel = (AbstractChannel)this.index().getChannelByChannelId(channelId);
        if (channel == null) {
            this.requestChannelReset(true, "Can't update channel with id " + String.valueOf(channelId) + " because it doesn't exist");
            return;
        }
        channel.update(properties);
        Laby.fireEvent((Event)new ChannelUpdateEvent(channel));
        this.checkForProximityChange();
    }

    public void onChannelHide(UUID channelId) {
        try {
            this.index.removeChannelByChannelId(channelId);
            Laby.fireEvent((Event)new ChannelHideEvent(channelId));
        }
        catch (Throwable t) {
            this.requestChannelReset(true, "Can't hide channel with id " + String.valueOf(channelId) + " because of an error: " + t.getMessage());
        }
    }

    public void onChannelReset() {
        this.logging.info((CharSequence)"Resetting channel index", new Object[0]);
        this.timeLastReset = TimeUtil.getCurrentTimeMillis();
        this.index.clear();
        Laby.fireEvent((Event)new ChannelResetEvent());
    }

    public void onUserShow(UUID userId, UUID channelId, UserProperties properties) {
        AbstractChannel channel = (AbstractChannel)this.index().getChannelByChannelId(channelId);
        if (channel == null) {
            this.requestChannelReset(true, "Can't add user with id " + String.valueOf(userId) + " to channel with id " + String.valueOf(channelId) + " because it doesn't exist");
            return;
        }
        DefaultChannelUser user = new DefaultChannelUser(userId, properties);
        if (user.isClient()) {
            if (!this.currentChannelId.equals(channelId)) {
                this.currentChannelId = channelId;
                this.playSound(channel instanceof LobbyChannel ? VoiceChatSounds.SOUND_CHANNEL_EXIT : VoiceChatSounds.SOUND_CHANNEL_SWITCH);
            }
        } else if (this.isClientInChannel(channel) && channel.hasSounds()) {
            this.playSound(VoiceChatSounds.SOUND_CHANNEL_JOIN);
        }
        try {
            this.index.addUserToChannel(channel, user);
            Laby.fireEvent((Event)new UserShowEvent(user, channel));
        }
        catch (IllegalArgumentException e) {
            this.requestChannelReset(true, "Can't add user with id " + String.valueOf(userId) + " to channel " + channel.getName() + " because of an error: " + e.getMessage());
        }
    }

    public void onUserSwitchChannel(UUID userId, UUID prevChannelId, UUID newChannelId, UserProperties properties) {
        this.onUserHide(userId, prevChannelId);
        this.onUserShow(userId, newChannelId, properties);
        if (userId.equals(VoiceChatAddon.getSessionId())) {
            Laby.fireEvent((Event)new ClientChannelSwitchEvent(prevChannelId, newChannelId));
            this.checkForProximityChange();
        }
    }

    public void onChannelUserUpdateProperties(UUID userId, UserProperties properties) {
        AbstractChannel channel = (AbstractChannel)this.index().getChannelByUserId(userId);
        if (channel == null) {
            return;
        }
        ChannelUser user = channel.users().getById(userId);
        if (user == null) {
            return;
        }
        for (Map.Entry property : properties.entrySet()) {
            user.properties().setProperty((UserProperties.Key)property.getKey(), property.getValue());
        }
        Laby.fireEvent((Event)new UserUpdateEvent(user));
    }

    public void onUserHide(UUID userId, UUID channelId) {
        AbstractChannel channel = (AbstractChannel)this.index().getChannelByChannelId(channelId);
        if (channel == null) {
            Channel actualChannel = this.index().getChannelByUserId(userId);
            this.requestChannelReset(true, "Can't remove user with id " + String.valueOf(userId) + " from channel with id " + String.valueOf(channelId) + " because the channel doesn't exist (actual channel: " + (String)(actualChannel != null ? "'" + actualChannel.getName() + "'" : "null") + ")");
            return;
        }
        ChannelUser user = channel.users().getById(userId);
        if (user == null) {
            Channel actualChannel = this.index().getChannelByUserId(userId);
            this.requestChannelReset(true, "Can't remove user with id " + String.valueOf(userId) + " from channel " + channel.getName() + " because the user doesn't exist in this channel (user is in channel: " + (String)(actualChannel != null ? "'" + actualChannel.getName() + "'" : "null") + ")");
            return;
        }
        if (!this.isClient(userId) && this.isClientInChannel(channel) && channel.hasSounds()) {
            this.playSound(VoiceChatSounds.SOUND_CHANNEL_LEAVE);
        }
        try {
            this.index.removeUserFromChannel(channel.getId(), user.getId());
            Laby.fireEvent((Event)new UserHideEvent(user.getId(), channel));
        }
        catch (IllegalArgumentException e) {
            this.requestChannelReset(true, "Can't remove user with id " + String.valueOf(userId) + " from channel " + channel.getName() + " because of an error: " + e.getMessage());
        }
    }

    private void checkForProximityChange() {
        boolean isProximity = this.isInProximity();
        if (this.prevIsProximity != isProximity) {
            this.prevIsProximity = isProximity;
            VoiceChatAddon.INSTANCE.referenceStorage().audioStreamRegistry().shutdownAllStreams();
        }
    }

    @Override
    public void sendClientProperties() {
        VoiceTransmitter transmitter = this.getTransmitter();
        if (transmitter == null || !this.hasSubscribed()) {
            return;
        }
        DeviceController devices = VoiceChatAddon.INSTANCE.referenceStorage().deviceController();
        UserProperties properties = new UserProperties();
        properties.setInputMuted(this.inputMuted);
        properties.setOutputMuted(this.outputMuted);
        properties.setInputDisabled(!devices.isInputDeviceRunning());
        properties.setOutputDisabled(!devices.isOutputDeviceRunning());
        Debounce.of((String)"sendVoiceChatClientProperties", (long)101L, () -> transmitter.sendUpdateProperties(properties));
        Laby.fireEvent((Event)new ClientPropertiesUpdateEvent(properties));
    }

    @Override
    public void subscribe() {
        VoiceTransmitter transmitter = this.getTransmitter();
        if (transmitter == null || this.subscribed) {
            return;
        }
        this.subscribed = true;
        transmitter.sendSubscribeChannels();
    }

    public void requestChannelReset(boolean critical, String reason) {
        VoiceTransmitter transmitter = this.getTransmitter();
        if (transmitter == null) {
            return;
        }
        Debounce.of((String)"requestChannelReset", (long)1000L, () -> {
            this.logging.error((CharSequence)("Requesting channel reset: " + reason), new Object[0]);
            transmitter.sendRequestChannelReset(critical, reason);
        });
    }

    @Subscribe(value=-127)
    public void onVoiceChatAuthenticated(VoiceChatAuthenticatedEvent event) {
        this.subscribed = false;
        this.currentChannelId = LobbyChannel.ID;
        this.index.clear();
    }

    @Subscribe(value=-127)
    public void onVoiceChatDisconnect(VoiceChatDisconnectEvent event) {
        this.subscribed = false;
        this.currentChannelId = LobbyChannel.ID;
        this.index.clear();
    }

    @Subscribe
    public void onDeviceStateChanged(DeviceStateChangedEvent event) {
        this.sendClientProperties();
    }

    @Subscribe
    public void onAudioTaskStateChanged(AudioTaskStateChangedEvent event) {
        this.sendClientProperties();
    }

    @Subscribe
    public void onUserUpdateData(UserUpdateDataEvent event) {
        Channel channel = this.index.getChannelByUserId(event.gameUser().getUniqueId());
        if (channel == null) {
            return;
        }
        channel.users().setDirty();
    }

    @Override
    @Nullable
    public ChannelUser getClientChannelUser() {
        Session session = this.getSession();
        if (session == null) {
            return null;
        }
        UUID userId = session.getUniqueId();
        Channel channel = this.getCurrentChannel();
        return channel == null ? null : channel.users().getById(userId);
    }

    @Override
    public boolean isInputMuted() {
        return this.inputMuted;
    }

    @Override
    public boolean isOutputMuted() {
        return this.outputMuted;
    }

    @Override
    public void setInputMuted(boolean inputMuted) {
        this.inputMuted = inputMuted;
        this.sendClientProperties();
        Laby.labyAPI().minecraft().sounds().playSound(VoiceChatSounds.SOUND_CHANNEL_MUTE, 1.0f, inputMuted ? 1.0f : 2.0f);
    }

    @Override
    public void setOutputMuted(boolean outputMuted) {
        this.outputMuted = outputMuted;
        this.sendClientProperties();
        Laby.labyAPI().minecraft().sounds().playSound(VoiceChatSounds.SOUND_CHANNEL_MUTE, 1.0f, outputMuted ? 1.0f : 2.0f);
    }

    @Override
    @NotNull
    public UUID getCurrentChannelId() {
        return this.currentChannelId;
    }

    @Nullable
    private VoiceTransmitter getTransmitter() {
        VoiceConnector connector = VoiceChatAddon.INSTANCE.referenceStorage().voiceConnector();
        return connector.isConnected() && connector.isAuthenticated() ? connector.transmitter() : null;
    }

    @Nullable
    private Session getSession() {
        return VoiceChatAddon.INSTANCE.referenceStorage().voiceConnector().getSession();
    }

    @Override
    public boolean hasSubscribed() {
        return this.subscribed;
    }

    @Override
    @NotNull
    public ChannelIndex index() {
        return this.index;
    }

    private boolean isClient(UUID userId) {
        Session session = this.getSession();
        return session != null && userId.equals(session.getUniqueId());
    }

    private boolean isClientInChannel(Channel channel) {
        return this.getCurrentChannelId().equals(channel.getId());
    }

    private boolean isDefaultChannel(UUID channelId) {
        return channelId.equals(LobbyChannel.ID);
    }

    private void playSound(ResourceLocation resourceLocation) {
        long timePassedSinceLastReset = TimeUtil.getCurrentTimeMillis() - this.timeLastReset;
        if (timePassedSinceLastReset < 1000L) {
            return;
        }
        MinecraftSounds soundManager = Laby.labyAPI().minecraft().sounds();
        soundManager.playSound(resourceLocation, 0.5f, 1.0f);
    }
}

