/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.channel;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.labymod.addons.voicechat.api.channel.Channel;
import net.labymod.addons.voicechat.api.channel.ChannelIndex;
import net.labymod.addons.voicechat.api.channel.ChannelUser;
import net.labymod.addons.voicechat.api.channel.util.Index;
import net.labymod.addons.voicechat.core.channel.channel.AbstractChannel;
import org.jetbrains.annotations.NotNull;

public class DefaultChannelIndex
implements ChannelIndex {
    private final Index<Channel> index = new Index<Channel>(Comparator.comparingLong(Channel::getCreationTime));
    private final Map<UUID, UUID> userId2ChannelId = new HashMap<UUID, UUID>();

    @Override
    public Channel getChannelByChannelId(UUID id) {
        return this.index.getById(id);
    }

    @Override
    public Channel getChannelByUserId(UUID userId) {
        UUID channelId = this.userId2ChannelId.get(userId);
        if (channelId == null) {
            return null;
        }
        return this.getChannelByChannelId(channelId);
    }

    @Override
    public ChannelUser getChannelUserById(UUID userId) {
        Channel channel = this.getChannelByUserId(userId);
        if (channel == null) {
            return null;
        }
        return channel.users().getById(userId);
    }

    public void addChannel(Channel channel) {
        this.index.add(channel);
        for (ChannelUser user : channel.users().unsorted()) {
            this.userId2ChannelId.put(user.getId(), channel.getId());
        }
    }

    public void addUserToChannel(Channel channel, ChannelUser user) {
        this.userId2ChannelId.put(user.getId(), channel.getId());
        ((AbstractChannel)channel).addUser(user);
    }

    public void removeUserFromChannel(UUID channelId, UUID userId) {
        UUID storedChannelId = this.userId2ChannelId.get(userId);
        if (storedChannelId == null || !storedChannelId.equals(channelId)) {
            throw new IllegalArgumentException("User with id " + String.valueOf(userId) + " not in the channel with id " + String.valueOf(channelId));
        }
        AbstractChannel channel = (AbstractChannel)this.getChannelByChannelId(channelId);
        if (channel == null) {
            throw new IllegalArgumentException("Channel with id " + String.valueOf(channelId) + " not found");
        }
        channel.removeUser(userId);
        this.userId2ChannelId.remove(userId);
    }

    public void removeChannelByChannelId(UUID id) {
        Channel channel = this.getChannelByChannelId(id);
        if (channel == null) {
            throw new IllegalArgumentException("Channel with id " + String.valueOf(id) + " not found");
        }
        this.removeChannel(channel);
    }

    public void removeChannel(Channel channel) {
        for (ChannelUser user : channel.users().unsorted()) {
            this.userId2ChannelId.remove(user.getId());
        }
        this.index.remove(channel);
    }

    public void clear() {
        this.userId2ChannelId.clear();
        this.index.clear();
    }

    @Override
    @NotNull
    public List<Channel> sorted() {
        return this.index.sorted();
    }

    @NotNull
    public List<Channel> unsorted() {
        return this.index.unsorted();
    }
}

