/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.client.transmitter;

import java.util.UUID;
import net.labymod.addons.voicechat.api.VoiceChat;
import net.labymod.addons.voicechat.api.audio.stream.AudioStreamRegistry;
import net.labymod.addons.voicechat.api.audio.stream.user.AudioStream;
import net.labymod.addons.voicechat.api.client.transmitter.VoiceTransmitter;
import net.labymod.addons.voicechat.api.client.user.moderate.MuteTemplate;
import net.labymod.addons.voicechat.core.audio.stream.user.AbstractAudioStream;
import net.labymod.api.client.network.server.ServerAddress;
import net.labymod.voice.client.VoiceClient;
import net.labymod.voice.protocol.util.properties.ChannelProperties;
import net.labymod.voice.protocol.util.properties.UserProperties;

public class DefaultVoiceTransmitter
implements VoiceTransmitter {
    private final VoiceChat voiceChat;
    private final VoiceClient voiceClient;
    private AudioStreamRegistry audioStreamRegistry;

    public DefaultVoiceTransmitter(VoiceChat voiceChat, VoiceClient voiceClient) {
        this.voiceChat = voiceChat;
        this.voiceClient = voiceClient;
    }

    @Override
    public void sendNetworkSwitch(ServerAddress address) {
        this.voiceClient.sendSwitchServer(address.getHost(), address.getPort());
    }

    @Override
    public void sendVisiblePlayers(UUID[] uuids) {
        this.voiceClient.sendVisiblePlayers(uuids);
    }

    @Override
    public void requestMetaUpdate(UUID uniqueId) {
        this.voiceClient.requestMetaUpdate(uniqueId);
    }

    @Override
    public void sendAudioChunk(byte[] data) {
        this.voiceClient.sendAudioChunk(data);
        if (this.audioStreamRegistry == null) {
            this.audioStreamRegistry = this.voiceChat.referenceStorage().audioStreamRegistry();
        }
        for (AudioStream stream : this.audioStreamRegistry.getStreams().values()) {
            if (!(stream instanceof AbstractAudioStream)) continue;
            ((AbstractAudioStream)stream).incrementTX(data.length);
        }
    }

    @Override
    public long mutePlayer(UUID uniqueId, String reason, long duration) {
        this.voiceClient.sendMutePlayer(uniqueId, reason, duration, -1);
        return duration;
    }

    @Override
    public void unmutePlayer(UUID uniqueId) {
        this.voiceClient.sendUnmutePlayer(uniqueId);
    }

    @Override
    public void reportPlayer(UUID uniqueId, MuteTemplate type) {
        this.voiceClient.sendReportPlayer(uniqueId, type.getIdentifier());
    }

    @Override
    public void warnPlayer(UUID uniqueId, String reason) {
        this.voiceClient.sendWarnPlayer(uniqueId, reason);
    }

    @Override
    public void addPlayerNote(UUID uniqueId, String note) {
        this.voiceClient.sendAddNotePlayer(uniqueId, note);
    }

    @Override
    public void updatePlayerNote(UUID uniqueId, int noteId, String note) {
        this.voiceClient.sendUpdateNotePlayer(uniqueId, noteId, note);
    }

    @Override
    public void removePlayerNote(UUID uniqueId, int noteId) {
        this.voiceClient.sendRemoveNotePlayer(uniqueId, noteId);
    }

    @Override
    public void sendSubscribeChannels() {
        this.voiceClient.sendSubscribeChannels();
    }

    @Override
    public void sendRequestChannelReset(boolean critical, String reason) {
        this.voiceClient.sendRequestChannelReset(critical, reason);
    }

    @Override
    public void sendCreateChannel(ChannelProperties properties) {
        this.voiceClient.sendCreateChannel(properties);
    }

    @Override
    public void sendUpdateChannel(UUID channelId, ChannelProperties properties) {
        this.voiceClient.sendUpdateChannel(channelId, properties);
    }

    @Override
    public void sendDeleteChannel(UUID channelId) {
        this.voiceClient.sendDeleteChannel(channelId);
    }

    @Override
    public void sendUpdateProperties(UserProperties properties) {
        this.voiceClient.sendUpdateProperties(properties);
    }

    @Override
    public void sendMovePlayerToChannel(UUID userId, UUID channelId) {
        this.voiceClient.sendMovePlayerToChannel(userId, channelId);
    }

    @Override
    public void sendMovePlayerToChannel(UUID userId, UUID channelId, String password) {
        this.voiceClient.sendMovePlayerToChannel(userId, channelId, password);
    }
}

