/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.client.user;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.inject.Singleton;
import net.labymod.addons.voicechat.api.client.user.VoiceUser;
import net.labymod.addons.voicechat.api.client.user.VoiceUserRegistry;
import net.labymod.addons.voicechat.core.client.user.DefaultVoiceUser;
import net.labymod.api.models.Implements;

@Singleton
@Implements(value=VoiceUserRegistry.class)
public class DefaultVoiceUserRegistry
implements VoiceUserRegistry {
    private final Map<UUID, VoiceUser> voiceUsers = new HashMap<UUID, VoiceUser>();

    @Override
    public VoiceUser getOrCreate(UUID uuid) {
        VoiceUser voiceUser = this.get(uuid);
        if (voiceUser == null) {
            voiceUser = new DefaultVoiceUser(uuid);
            this.voiceUsers.put(uuid, voiceUser);
        }
        return voiceUser;
    }

    @Override
    public VoiceUser get(UUID uuid) {
        return this.voiceUsers.get(uuid);
    }

    @Override
    public boolean has(UUID uniqueId) {
        return this.get(uniqueId) != null;
    }

    @Override
    public void purge() {
        this.voiceUsers.clear();
    }

    @Override
    public Collection<VoiceUser> getAll() {
        return this.voiceUsers.values();
    }
}

