/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.configuration;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.labymod.addons.voicechat.api.configuration.FocusedUsers;
import net.labymod.api.models.Implements;
import net.labymod.api.util.time.TimeUtil;

@Singleton
@Implements(value=FocusedUsers.class)
public class DefaultFocusedUsers
implements FocusedUsers {
    private final Map<UUID, String> users = new HashMap<UUID, String>();
    private UUID tempUser;
    private long tempUserUntil;

    @Inject
    public DefaultFocusedUsers() {
    }

    @Override
    public boolean isFocused(UUID uniqueId) {
        return this.isPermanentFocused(uniqueId) || this.hasTempFocused(uniqueId);
    }

    @Override
    public boolean isPermanentFocused(UUID uniqueId) {
        return this.users.containsKey(uniqueId);
    }

    @Override
    public boolean isActive() {
        return !this.users.isEmpty() || this.hasTempFocused();
    }

    @Override
    public Collection<String> getNames() {
        return this.users.values();
    }

    @Override
    public void focus(UUID uniqueId, String username) {
        this.users.put(uniqueId, username);
    }

    @Override
    public void unfocus(UUID uniqueId) {
        this.users.remove(uniqueId);
        this.tempUser = null;
        this.tempUserUntil = 0L;
    }

    @Override
    public void clear() {
        this.users.clear();
        this.tempUser = null;
        this.tempUserUntil = 0L;
    }

    @Override
    public boolean hasTempFocused(UUID uniqueId) {
        return this.tempUser != null && this.tempUser.equals(uniqueId) && TimeUtil.getCurrentTimeMillis() < this.tempUserUntil;
    }

    @Override
    public boolean hasTempFocused() {
        return this.tempUser != null && TimeUtil.getCurrentTimeMillis() < this.tempUserUntil;
    }

    @Override
    public void focus(UUID uniqueId, long duration) {
        this.tempUser = uniqueId;
        this.tempUserUntil = TimeUtil.getCurrentTimeMillis() + duration;
    }
}

