/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.listener;

import net.labymod.addons.voicechat.api.channel.Channel;
import net.labymod.addons.voicechat.api.channel.ChannelController;
import net.labymod.addons.voicechat.api.client.VoiceConnector;
import net.labymod.addons.voicechat.core.configuration.DefaultVoiceChatConfiguration;
import net.labymod.addons.voicechat.core.generated.DefaultReferenceStorage;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.screen.key.Key;
import net.labymod.api.client.network.server.ServerAddress;
import net.labymod.api.client.network.server.ServerData;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.client.network.server.ServerDisconnectEvent;
import net.labymod.api.event.client.network.server.ServerJoinEvent;
import net.labymod.api.event.client.network.server.ServerSwitchEvent;
import net.labymod.api.event.client.network.server.SubServerSwitchEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NetworkListener {
    private final DefaultVoiceChatConfiguration configuration;
    private final VoiceConnector connector;
    private final ChannelController channelController;

    public NetworkListener(DefaultReferenceStorage references) {
        this.configuration = (DefaultVoiceChatConfiguration)references.voiceChat().configuration();
        this.connector = references.voiceConnector();
        this.channelController = references.channelController();
    }

    @Subscribe
    public void onServerJoin(ServerJoinEvent event) {
        this.updateServer((ServerData)event.serverData());
        if (!this.configuration.hasCompletedTutorial(0)) {
            String keyName = ((Key)this.configuration.voiceChannelsKey().get()).getName();
            Laby.labyAPI().minecraft().chatExecutor().displayClientMessage((Component)Component.translatable((String)"voicechat.tutorial.hotkey", (TextColor)NamedTextColor.GRAY).argument((Component)Component.text((String)("[" + keyName + "]"), (TextColor)NamedTextColor.YELLOW)));
        }
    }

    @Subscribe
    public void onServerSwitch(ServerSwitchEvent event) {
        this.updateServer((ServerData)event.newServerData());
    }

    @Subscribe
    public void onSubServerSwitch(@NotNull SubServerSwitchEvent event) {
        this.updateServer((ServerData)event.serverData());
    }

    @Subscribe
    public void onServerDisconnect(ServerDisconnectEvent event) {
        this.updateServer(null);
    }

    private void updateServer(@Nullable ServerData serverData) {
        if (this.connector.isConnected() && this.connector.isAuthenticated()) {
            this.connector.transmitter().sendNetworkSwitch(serverData == null ? new ServerAddress("", 25565) : serverData.address());
            Channel channel = this.channelController.getCurrentChannel();
            if (channel != null && channel.isClientOwner()) {
                channel.properties().setServerAddress(serverData == null ? null : serverData.address().toString());
                this.connector.transmitter().sendUpdateChannel(channel.getId(), channel.properties());
            }
        }
        if (!this.connector.isConnected()) {
            this.connector.connect();
        }
    }
}

