/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.ui.activity.channel;

import java.util.Locale;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.labymod.addons.voicechat.api.channel.Channel;
import net.labymod.addons.voicechat.api.channel.ChannelController;
import net.labymod.addons.voicechat.api.channel.ChannelUser;
import net.labymod.addons.voicechat.api.client.VoiceConnector;
import net.labymod.addons.voicechat.api.client.transmitter.VoiceTransmitter;
import net.labymod.addons.voicechat.api.event.VoiceChatAuthenticatedEvent;
import net.labymod.addons.voicechat.api.event.channel.ChannelHideEvent;
import net.labymod.addons.voicechat.api.event.channel.ChannelResetEvent;
import net.labymod.addons.voicechat.api.event.channel.ChannelShowEvent;
import net.labymod.addons.voicechat.api.event.channel.ChannelUpdateEvent;
import net.labymod.addons.voicechat.api.event.channel.ClientPropertiesUpdateEvent;
import net.labymod.addons.voicechat.api.event.channel.UserHideEvent;
import net.labymod.addons.voicechat.api.event.channel.UserShowEvent;
import net.labymod.addons.voicechat.api.event.channel.UserUpdateEvent;
import net.labymod.addons.voicechat.api.event.moderation.VoiceUserVisibilityChangedEvent;
import net.labymod.addons.voicechat.api.event.stream.AudioStreamShutdownEvent;
import net.labymod.addons.voicechat.api.event.stream.AudioStreamStartEvent;
import net.labymod.addons.voicechat.api.event.stream.AudioStreamTalkingStateChangedEvent;
import net.labymod.addons.voicechat.api.ui.VoiceChatTextures;
import net.labymod.addons.voicechat.core.VoiceChatAddon;
import net.labymod.addons.voicechat.core.channel.channel.LobbyChannel;
import net.labymod.addons.voicechat.core.configuration.DefaultVoiceChatConfiguration;
import net.labymod.addons.voicechat.core.generated.DefaultReferenceStorage;
import net.labymod.addons.voicechat.core.ui.activity.channel.popup.EditChannelPopup;
import net.labymod.addons.voicechat.core.ui.activity.channel.widget.VoiceChannelListWidget;
import net.labymod.addons.voicechat.core.ui.activity.channel.widget.VoiceChannelUserWidget;
import net.labymod.addons.voicechat.core.ui.activity.channel.widget.VoiceChannelWidget;
import net.labymod.addons.voicechat.core.ui.activity.channel.widget.VoiceWindowWidget;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TranslatableComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.ScreenContext;
import net.labymod.api.client.gui.screen.activity.AutoActivity;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.activity.types.SimpleActivity;
import net.labymod.api.client.gui.screen.key.InputType;
import net.labymod.api.client.gui.screen.key.Key;
import net.labymod.api.client.gui.screen.key.KeyHandler;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.action.ListSession;
import net.labymod.api.client.gui.screen.widget.attributes.bounds.Bounds;
import net.labymod.api.client.gui.screen.widget.context.ContextMenuEntry;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.DivWidget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.Document;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.TextFieldWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.ScrollWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.entry.FlexibleContentEntry;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;
import net.labymod.api.client.render.font.FontSize;
import net.labymod.api.configuration.settings.Setting;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.labymod.user.UserUpdateDataEvent;
import net.labymod.api.util.I18n;
import net.labymod.voice.protocol.util.properties.ChannelVisibility;
import org.jetbrains.annotations.NotNull;

@Link(value="voicechat-channels.lss")
@AutoActivity
public class VoiceChannelsActivity
extends SimpleActivity {
    private static ChannelVisibility selectedTab = ChannelVisibility.SERVER;
    private static String queryString = "";
    private static final ListSession<VoiceChannelWidget> listSession = new ListSession();
    private final ChannelController controller;
    @NotNull
    private final VoiceConnector voiceConnector;
    private final VoiceTransmitter transmitter;
    private final Queue<Runnable> updateQueue = new ConcurrentLinkedQueue<Runnable>();
    private final DefaultVoiceChatConfiguration config;
    private HorizontalListWidget tabs;
    private VoiceChannelListWidget channelList;
    private IconWidget leaveButton;
    private IconWidget inputMuteButton;
    private IconWidget outputMuteButton;
    private FlexibleContentWidget searchWrapper;
    private TextFieldWidget searchWidget;
    private ChannelVisibility lastIndicatorTab;
    private boolean hasChannelListWidget = false;

    public VoiceChannelsActivity() {
        Channel currentChannel;
        DefaultReferenceStorage reference = VoiceChatAddon.INSTANCE.referenceStorage();
        this.controller = reference.channelController();
        this.voiceConnector = reference.voiceConnector();
        this.transmitter = this.voiceConnector.transmitter();
        if (!this.controller.hasSubscribed()) {
            this.controller.subscribe();
        }
        this.config = (DefaultVoiceChatConfiguration)reference.voiceChat().configuration();
        if (!this.config.hasCompletedTutorial(0)) {
            this.config.setTutorialCompleted(0);
        }
        if ((currentChannel = this.controller.getCurrentChannel()) != null) {
            selectedTab = currentChannel.properties().getVisibility();
        }
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        VoiceWindowWidget windowWidget = new VoiceWindowWidget();
        windowWidget.addId("window");
        HorizontalListWidget header = new HorizontalListWidget();
        header.addId("header");
        ComponentWidget titleWidget = ComponentWidget.i18n((String)"voicechat.activity.channels.title");
        titleWidget.addId("title");
        header.addEntry((Widget)titleWidget);
        IconWidget settingsButton = new IconWidget(VoiceChatTextures.SpriteCommon.CHANNEL_SETTINGS);
        settingsButton.addId(new String[]{"settings-button", "button"});
        settingsButton.setHoverComponent((Component)Component.translatable((String)"voicechat.activity.channels.buttons.settings", (Component[])new Component[0]));
        settingsButton.setPressable(() -> {
            Setting setting = (Setting)this.labyAPI.coreSettingRegistry().getById("voicechat");
            if (setting == null) {
                return;
            }
            this.labyAPI.showSetting(setting);
            this.labyAPI.minecraft().sounds().playButtonPress();
        });
        header.addEntry((Widget)settingsButton);
        IconWidget createButton = new IconWidget(VoiceChatTextures.SpriteCommon.CHANNEL_CREATE);
        createButton.addId(new String[]{"create-button", "button"});
        createButton.setHoverComponent((Component)Component.translatable((String)"voicechat.activity.channels.buttons.create", (Component[])new Component[0]));
        createButton.setPressable(this::createChannel);
        createButton.setVisible(this.voiceConnector.isConnected() && this.voiceConnector.isAuthenticated());
        header.addEntry((Widget)createButton);
        this.outputMuteButton = new IconWidget(VoiceChatTextures.SpriteCommon.CHANNEL_OUTPUT);
        this.outputMuteButton.addId(new String[]{"output-mute-button", "button"});
        this.outputMuteButton.setPressable(this::toggleOutput);
        header.addEntry((Widget)this.outputMuteButton);
        this.inputMuteButton = new IconWidget(VoiceChatTextures.SpriteCommon.CHANNEL_INPUT);
        this.inputMuteButton.addId(new String[]{"input-mute-button", "button"});
        this.inputMuteButton.setPressable(this::toggleInput);
        header.addEntry((Widget)this.inputMuteButton);
        this.leaveButton = new IconWidget(VoiceChatTextures.SpriteCommon.CHANNEL_LEAVE);
        this.leaveButton.addId(new String[]{"leave-button", "button"});
        this.leaveButton.setHoverComponent((Component)Component.translatable((String)"voicechat.activity.channels.buttons.leave", (Component[])new Component[0]));
        this.leaveButton.setPressable(this::leaveChannel);
        header.addEntry((Widget)this.leaveButton);
        windowWidget.addContent((Widget)header);
        this.tabs = new HorizontalListWidget();
        this.tabs.addId("tabs");
        this.updateTabs(this.tabs);
        windowWidget.addContent((Widget)this.tabs);
        this.searchWrapper = new FlexibleContentWidget();
        this.searchWrapper.addId("search-wrapper");
        this.searchWrapper.setVisible(!queryString.isEmpty());
        IconWidget searchIcon = new IconWidget(VoiceChatTextures.SpriteWindow.SEARCH);
        searchIcon.addId("icon");
        this.searchWrapper.addContent((Widget)searchIcon);
        this.searchWidget = new TextFieldWidget();
        this.searchWidget.addId("search");
        this.searchWidget.setText(queryString);
        this.searchWidget.placeholder((Component)Component.translatable((String)"labymod.ui.textfield.search", (Component[])new Component[0]));
        this.searchWidget.updateListener(query -> {
            queryString = query;
            this.applyQuery();
        });
        this.searchWrapper.addFlexibleContent((Widget)this.searchWidget);
        windowWidget.addContent((Widget)this.searchWrapper);
        this.channelList = new VoiceChannelListWidget(this.controller, listSession);
        this.channelList.addId("channels");
        for (Channel channel : this.controller.index().sorted()) {
            if (!channel.isVisibleForVisibility(selectedTab)) continue;
            VoiceChannelWidget channelWidget = new VoiceChannelWidget(channel);
            this.channelList.addChild((Widget)channelWidget);
        }
        if (this.channelList.getChildren().isEmpty()) {
            DivWidget emptyWidget = new DivWidget();
            emptyWidget.addId("empty");
            ComponentWidget messageWidget = ComponentWidget.i18n((String)"voicechat.activity.channels.empty", (TextColor)NamedTextColor.GRAY);
            messageWidget.addId("message");
            emptyWidget.addChild((Widget)messageWidget);
            windowWidget.addFlexibleContent((Widget)emptyWidget);
            this.hasChannelListWidget = false;
        } else {
            ScrollWidget scrollWidget = new ScrollWidget((Widget)this.channelList, listSession);
            scrollWidget.addId("scroll");
            windowWidget.addFlexibleContent((Widget)scrollWidget);
            this.hasChannelListWidget = true;
        }
        if (!this.labyAPI.minecraft().isIngame()) {
            ButtonWidget doneButton = ButtonWidget.i18n((String)"labymod.ui.button.done");
            doneButton.addId("done-button");
            doneButton.setPressable(() -> ((VoiceChannelsActivity)this).displayPreviousScreen());
            windowWidget.addContent((Widget)doneButton);
        }
        ((Document)this.document).addChild((Widget)windowWidget);
        this.updateUI();
        this.applyQuery();
        this.updateQueue.clear();
    }

    private void applyQuery() {
        for (VoiceChannelWidget child : this.channelList.getChildren()) {
            child.setVisible(child.getChannel().matchesQuery(queryString));
        }
    }

    private void updateTabs(HorizontalListWidget tabs) {
        tabs.removeChildIf(horizontalListEntry -> true);
        Channel currentChannel = this.controller.getCurrentChannel();
        this.lastIndicatorTab = null;
        for (ChannelVisibility filter : ChannelVisibility.VALUES) {
            boolean isActive = filter == selectedTab;
            HorizontalListWidget tabWidget = new HorizontalListWidget();
            tabWidget.addId("tab");
            if (isActive) {
                tabWidget.setActive(true);
            }
            tabWidget.setPressable(() -> {
                if (selectedTab == filter) {
                    return;
                }
                selectedTab = filter;
                Laby.labyAPI().minecraft().sounds().playButtonPress();
                this.reload();
            });
            tabWidget.createContextMenu().addEntry(ContextMenuEntry.builder().text((Component)Component.translatable((String)"voicechat.activity.channels.buttons.create", (Component[])new Component[0])).clickHandler(entry -> {
                selectedTab = filter;
                this.reload();
                this.createChannel();
                return true;
            }).build());
            Icon icon = filter == ChannelVisibility.PUBLIC ? VoiceChatTextures.SpriteCommon.CHANNEL_PUBLIC : (filter == ChannelVisibility.FRIENDS ? VoiceChatTextures.SpriteCommon.CHANNEL_FRIEND : VoiceChatTextures.SpriteCommon.CHANNEL_SERVER);
            IconWidget iconWidget = new IconWidget(icon);
            iconWidget.addId("icon");
            tabWidget.addEntry((Widget)iconWidget);
            String key = filter.name().toLowerCase(Locale.ENGLISH);
            TranslatableComponent component = Component.translatable((String)("voicechat.activity.channels.tabs." + key), (Component[])new Component[0]);
            ComponentWidget nameWidget = ComponentWidget.component((Component)component);
            nameWidget.addId(new String[]{"name", key});
            tabWidget.addEntry((Widget)nameWidget);
            if (currentChannel != null && currentChannel.properties().getVisibility() == filter) {
                IconWidget indicator = new IconWidget(VoiceChatTextures.SpriteCommon.CHANNEL_ACTIVE_TAB);
                indicator.addId("indicator");
                tabWidget.addEntry((Widget)indicator);
                this.lastIndicatorTab = filter;
            }
            if (((Document)this.document).isInitialized()) {
                tabs.addEntryInitialized((Widget)tabWidget);
                continue;
            }
            tabs.addEntry((Widget)tabWidget);
        }
    }

    private void toggleInput() {
        this.controller.setInputMuted(!this.controller.isInputMuted());
        this.updateUI();
    }

    private void toggleOutput() {
        this.controller.setOutputMuted(!this.controller.isOutputMuted());
        this.updateUI();
    }

    private void leaveChannel() {
        ChannelUser user = this.controller.getClientChannelUser();
        if (user != null) {
            this.transmitter.sendMovePlayerToChannel(user.getId(), LobbyChannel.ID);
        }
    }

    private void createChannel() {
        EditChannelPopup.create(selectedTab).displayInOverlay();
    }

    public boolean keyPressed(Key key, InputType type) {
        if (KeyHandler.isControlDown() && key == Key.F && type == InputType.ACTION) {
            this.searchWidget.setText("");
            ((FlexibleContentEntry)this.searchWrapper.getChildren().get(1)).setFocused(true);
            this.searchWrapper.setVisible(!this.searchWrapper.isVisible());
            this.config.setTutorialCompleted(1);
            return true;
        }
        return super.keyPressed(key, type);
    }

    public void render(ScreenContext context) {
        super.render(context);
        if (!this.config.hasCompletedTutorial(1)) {
            float guiScale = this.labyAPI.minecraft().minecraftWindow().getScale();
            Bounds bounds = this.bounds();
            context.canvas().submitText(I18n.translate((String)"voicechat.tutorial.search", (Object[])new Object[0]), bounds.getWidth() / 2.0f, bounds.getHeight() * 0.96f, NamedTextColor.WHITE.getValue(), FontSize.PredefinedFontSize.SMALL.value((int)guiScale), 3);
        }
    }

    public void tick() {
        Runnable runnable;
        super.tick();
        while ((runnable = this.updateQueue.poll()) != null) {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private void updateUI() {
        boolean requiresChannelListWidget;
        ChannelVisibility currentSelectedTab;
        boolean inChannel = this.controller.isInCustomChannel();
        this.leaveButton.setVisible(inChannel);
        this.inputMuteButton.setVisible(true);
        this.inputMuteButton.icon().set((Object)(this.controller.isInputMuted() ? VoiceChatTextures.SpriteCommon.CHANNEL_INPUT_MUTE : VoiceChatTextures.SpriteCommon.CHANNEL_INPUT));
        this.inputMuteButton.setHoverComponent((Component)Component.translatable((String)(this.controller.isInputMuted() ? "voicechat.activity.channels.buttons.unmuteInput" : "voicechat.activity.channels.buttons.muteInput"), (Component[])new Component[0]));
        this.outputMuteButton.setVisible(true);
        this.outputMuteButton.icon().set((Object)(this.controller.isOutputMuted() ? VoiceChatTextures.SpriteCommon.CHANNEL_OUTPUT_MUTE : VoiceChatTextures.SpriteCommon.CHANNEL_OUTPUT));
        this.outputMuteButton.setHoverComponent((Component)Component.translatable((String)(this.controller.isOutputMuted() ? "voicechat.activity.channels.buttons.unmuteOutput" : "voicechat.activity.channels.buttons.muteOutput"), (Component[])new Component[0]));
        Channel currentChannel = this.controller.getCurrentChannel();
        ChannelVisibility channelVisibility = currentSelectedTab = currentChannel == null ? null : currentChannel.properties().getVisibility();
        if (this.lastIndicatorTab != currentSelectedTab) {
            if (selectedTab == currentSelectedTab) {
                this.updateTabs(this.tabs);
            } else {
                selectedTab = currentSelectedTab;
                this.reload();
                return;
            }
        }
        boolean bl = requiresChannelListWidget = !this.channelList.getChildren().isEmpty();
        if (this.hasChannelListWidget != requiresChannelListWidget) {
            this.reload();
        }
    }

    private void showChannel(Channel channel) {
        if (!channel.isVisibleForVisibility(selectedTab)) {
            return;
        }
        VoiceChannelWidget widget = this.getChannelWidgetById(channel.getId());
        if (widget != null) {
            throw new IllegalStateException("Can't show channel because widget for channel " + channel.getName() + " already exists");
        }
        this.channelList.addChildInitialized((Widget)new VoiceChannelWidget(channel));
        this.updateUI();
    }

    private void updateChannel(Channel channel) {
        boolean visible = channel.isVisibleForVisibility(selectedTab);
        VoiceChannelWidget widget = this.getChannelWidgetById(channel.getId());
        if (widget == null && visible) {
            this.channelList.addChildInitialized((Widget)new VoiceChannelWidget(channel));
        } else if (widget != null && !visible) {
            this.channelList.removeChild((Widget)widget);
        } else if (widget != null) {
            widget.reInitialize();
        }
        this.updateUI();
    }

    private void hideChannel(UUID channelId) {
        VoiceChannelWidget widget = this.getChannelWidgetById(channelId);
        if (widget == null) {
            return;
        }
        this.channelList.removeChild((Widget)widget);
        this.updateUI();
    }

    private void showUser(Channel channel, ChannelUser user) {
        if (!channel.isVisibleForVisibility(selectedTab)) {
            return;
        }
        VoiceChannelWidget widget = this.getChannelWidgetById(channel.getId());
        if (widget == null) {
            throw new IllegalStateException("Can't add user because widget for channel " + channel.getName() + " not found");
        }
        widget.addUser(user);
        this.channelList.updateBounds();
        this.updateUI();
    }

    private void updateUser(UUID userId) {
        VoiceChannelUserWidget widget = this.getUserWidgetById(userId);
        if (widget == null) {
            return;
        }
        widget.reInitialize();
    }

    private void hideUser(Channel channel, UUID userId) {
        if (!channel.isVisibleForVisibility(selectedTab)) {
            return;
        }
        VoiceChannelWidget widget = this.getChannelWidgetById(channel.getId());
        if (widget == null) {
            throw new IllegalStateException("Can't remove user because widget for channel " + channel.getName() + " not found");
        }
        widget.removeUser(userId);
        this.channelList.updateBounds();
        this.updateUI();
    }

    @Subscribe
    public void onVoiceChatAuthenticated(VoiceChatAuthenticatedEvent event) {
        this.controller.subscribe();
        this.controller.sendClientProperties();
        this.pushToQueue(() -> ((VoiceChannelsActivity)this).reload());
    }

    @Subscribe
    public void onChannelShow(ChannelShowEvent event) {
        this.pushToQueue(() -> this.showChannel(event.channel()));
    }

    @Subscribe
    public void onChannelUpdate(ChannelUpdateEvent event) {
        this.pushToQueue(() -> this.updateChannel(event.channel()));
    }

    @Subscribe
    public void onChannelHide(ChannelHideEvent event) {
        this.pushToQueue(() -> this.hideChannel(event.getChannelId()));
    }

    @Subscribe
    public void onChannelReset(ChannelResetEvent event) {
        this.pushToQueue(() -> ((VoiceChannelsActivity)this).reload());
    }

    @Subscribe
    public void onUserUpdateData(UserUpdateDataEvent event) {
        this.pushToQueue(() -> this.updateUser(event.gameUser().getUniqueId()));
    }

    @Subscribe
    public void onUserShow(UserShowEvent event) {
        this.pushToQueue(() -> {
            this.showUser(event.channel(), event.user());
            this.updateUI();
        });
    }

    @Subscribe
    public void onUserUpdate(UserUpdateEvent event) {
        this.pushToQueue(() -> this.updateUser(event.user().getId()));
    }

    @Subscribe
    public void onUserHide(UserHideEvent event) {
        this.pushToQueue(() -> this.hideUser(event.channel(), event.getUserId()));
    }

    @Subscribe
    public void onAudioStreamStart(AudioStreamStartEvent event) {
        this.pushToQueue(() -> this.updateUser(event.voiceUser().getUniqueId()));
    }

    @Subscribe
    public void onAudioStreamShutdown(AudioStreamShutdownEvent event) {
        this.pushToQueue(() -> this.updateUser(event.voiceUser().getUniqueId()));
    }

    @Subscribe
    public void onAudioStreamStateChange(AudioStreamTalkingStateChangedEvent event) {
        this.pushToQueue(() -> this.updateUser(event.audioStream().getId()));
    }

    @Subscribe
    public void onVoiceUserVisibilityChanged(VoiceUserVisibilityChangedEvent event) {
        this.pushToQueue(() -> this.updateUser(event.voiceUser().getUniqueId()));
    }

    @Subscribe
    public void onClientPropertiesUpdate(ClientPropertiesUpdateEvent event) {
        this.pushToQueue(this::updateUI);
    }

    public VoiceChannelWidget getChannelWidgetById(UUID channelId) {
        if (!((Document)this.document).isInitialized()) {
            return null;
        }
        for (VoiceChannelWidget widget : this.channelList.getChildren()) {
            if (!widget.getChannel().getId().equals(channelId)) continue;
            return widget;
        }
        return null;
    }

    public VoiceChannelUserWidget getUserWidgetById(UUID userId) {
        if (!((Document)this.document).isInitialized()) {
            return null;
        }
        for (VoiceChannelWidget widget : this.channelList.getChildren()) {
            VoiceChannelUserWidget userWidget = widget.getUserWidgetById(userId);
            if (userWidget == null) continue;
            return userWidget;
        }
        return null;
    }

    private void pushToQueue(Runnable runnable) {
        if (!((Document)this.document).isInitialized()) {
            return;
        }
        this.updateQueue.add(runnable);
    }
}

