/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.ui.config.device;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import net.labymod.addons.voicechat.api.audio.device.Device;
import net.labymod.addons.voicechat.api.audio.device.DeviceController;
import net.labymod.addons.voicechat.api.audio.device.DeviceInformation;
import net.labymod.addons.voicechat.api.audio.device.util.DeviceType;
import net.labymod.addons.voicechat.core.VoiceChatAddon;
import net.labymod.addons.voicechat.core.configuration.DefaultVoiceChatConfiguration;
import net.labymod.addons.voicechat.core.listener.SettingListener;
import net.labymod.addons.voicechat.core.ui.config.device.DeviceEntryRenderer;
import net.labymod.api.Textures;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.SliderWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.dropdown.DropdownWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.dropdown.renderer.EntryRenderer;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.configuration.loader.Config;
import net.labymod.api.configuration.loader.property.ConfigProperty;
import net.labymod.api.configuration.settings.Setting;
import net.labymod.api.configuration.settings.accessor.SettingAccessor;
import net.labymod.api.configuration.settings.annotation.SettingElement;
import net.labymod.api.configuration.settings.annotation.SettingFactory;
import net.labymod.api.configuration.settings.annotation.SettingWidget;
import net.labymod.api.configuration.settings.widget.WidgetFactory;
import net.labymod.api.util.logging.Logging;
import org.jetbrains.annotations.Nullable;

@AutoWidget
@SettingWidget
@Link(value="device-configurator.lss")
public class DeviceConfiguratorWidget
extends FlexibleContentWidget {
    private static final Logging LOGGING = Logging.getLogger();
    private final DeviceConfiguratorSetting setting;
    private final SettingAccessor deviceNameAccessor;
    private final SettingAccessor volumeAccessor;
    private final DeviceController controller;
    private ButtonWidget refreshButton;
    private DropdownWidget<DeviceInformation> deviceDropdown;
    private SliderWidget volumeSlider;

    public DeviceConfiguratorWidget(DeviceConfiguratorSetting setting, SettingAccessor deviceNameAccessor, SettingAccessor volumeAccessor) {
        this.setting = setting;
        this.deviceNameAccessor = deviceNameAccessor;
        this.volumeAccessor = volumeAccessor;
        this.controller = VoiceChatAddon.INSTANCE.referenceStorage().deviceController();
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        SliderWidget.SliderSetting sliderSetting = this.setting.volumeSliderSetting();
        this.volumeSlider = new SliderWidget(sliderSetting.steps(), arg_0 -> ((SettingAccessor)this.volumeAccessor).set(arg_0));
        this.volumeSlider.addId("volume-slider");
        this.volumeSlider.range(sliderSetting.min(), sliderSetting.max());
        this.volumeSlider.setValue((double)((Float)this.volumeAccessor.get()).floatValue());
        this.volumeSlider.setHoverComponent((Component)Component.translatable((String)("voicechat.settings." + this.setting.volumePropertyName() + ".name"), (Component[])new Component[0]));
        this.volumeAccessor.property().addChangeListener((t, oldValue, newValue) -> this.volumeSlider.setValue((double)((Float)newValue).floatValue()));
        SettingListener.applyDecibelFormatter(this.volumeSlider);
        this.addContent((Widget)this.volumeSlider);
        this.deviceDropdown = new DropdownWidget();
        this.deviceDropdown.addId("device-dropdown");
        this.deviceDropdown.setEntryRenderer((EntryRenderer)new DeviceEntryRenderer());
        this.deviceDropdown.setChangeListener(device -> {
            this.deviceNameAccessor.set((Object)device.getIdentifier().toString());
            this.setSelectedDevice((DeviceInformation)device);
        });
        this.deviceNameAccessor.property().addChangeListener((t, oldValue, newValue) -> {
            DeviceInformation device = this.controller.getDeviceByIdentifier(this.setting.type(), (String)newValue);
            if (device != null) {
                this.deviceDropdown.setSelected((Object)device);
            }
        });
        this.addFlexibleContent((Widget)this.deviceDropdown);
        this.refreshButton = ButtonWidget.icon((Icon)Textures.SpriteCommon.REFRESH);
        this.refreshButton.addId("refresh-button");
        this.refreshButton.setPressable(() -> {
            this.controller.updateDevice(this.setting.type());
            this.updateDropdown();
        });
        this.refreshButton.setHoverComponent((Component)Component.translatable((String)"labymod.ui.button.refresh", (Component[])new Component[0]));
        this.addContent((Widget)this.refreshButton);
        this.updateDropdown();
    }

    private void updateDropdown() {
        DeviceType type = this.setting.type();
        Collection<DeviceInformation> inputDevices = this.controller.getDevices(type);
        this.deviceDropdown.clear();
        for (DeviceInformation device : inputDevices) {
            this.deviceDropdown.add((Object)device);
        }
        Device selectedDevice = this.controller.getSelectedDevice(this.setting.type());
        if (selectedDevice != null) {
            this.deviceDropdown.setSelected((Object)selectedDevice.information());
        }
    }

    private void setSelectedDevice(DeviceInformation device) {
        try {
            this.controller.setSelectedDevice(device.create());
        }
        catch (Exception e) {
            LOGGING.warn((CharSequence)("Failed to set device: " + e.getMessage()), new Object[0]);
        }
    }

    public void tick() {
        super.tick();
    }

    public void dispose() {
        super.dispose();
    }

    @SettingElement(extended=true)
    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface DeviceConfiguratorSetting {
        public DeviceType type();

        public SliderWidget.SliderSetting volumeSliderSetting();

        public String volumePropertyName();
    }

    @SettingFactory
    public static class Factory
    implements WidgetFactory<DeviceConfiguratorSetting, DeviceConfiguratorWidget> {
        public DeviceConfiguratorWidget[] create(Setting setting, DeviceConfiguratorSetting annotation, SettingAccessor deviceNameAccessor) {
            return new DeviceConfiguratorWidget[]{new DeviceConfiguratorWidget(annotation, deviceNameAccessor, this.getSettingAccessorOf(deviceNameAccessor.config(), annotation.type(), annotation.volumePropertyName()))};
        }

        @Deprecated
        private SettingAccessor getSettingAccessorOf(Config config, DeviceType type, String propertyName) {
            final ConfigProperty<Float> property = switch (type) {
                default -> throw new MatchException(null, null);
                case DeviceType.INPUT -> ((DefaultVoiceChatConfiguration)config).inputVolume();
                case DeviceType.OUTPUT -> ((DefaultVoiceChatConfiguration)config).outputVolume();
            };
            return new SettingAccessor(){

                public Class<?> getType() {
                    throw new UnsupportedOperationException();
                }

                @Nullable
                public Type getGenericType() {
                    throw new UnsupportedOperationException();
                }

                public Field getField() {
                    throw new UnsupportedOperationException();
                }

                public Config config() {
                    throw new UnsupportedOperationException();
                }

                public <T> void set(T t) {
                    property.set((Object)((Float)t));
                }

                public <T> T get() {
                    return (T)property.get();
                }

                public <T> ConfigProperty<T> property() {
                    return property;
                }

                public net.labymod.api.configuration.settings.type.SettingElement setting() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public Class<?>[] types() {
            return new Class[0];
        }
    }
}

