/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.ui.hudwidget;

import net.labymod.addons.voicechat.api.ClientVoiceState;
import net.labymod.addons.voicechat.api.VoiceChat;
import net.labymod.addons.voicechat.api.audio.stream.AudioStreamState;
import net.labymod.addons.voicechat.api.client.user.VoiceUser;
import net.labymod.addons.voicechat.api.client.user.VoiceUserRegistry;
import net.labymod.addons.voicechat.api.client.user.moderate.Mute;
import net.labymod.addons.voicechat.core.VoiceChatAddon;
import net.labymod.api.client.Minecraft;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.TranslatableComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.entity.player.ClientPlayer;
import net.labymod.api.client.gui.hud.hudwidget.HudWidgetConfig;
import net.labymod.api.client.gui.hud.hudwidget.SimpleHudWidget;
import net.labymod.api.client.gui.hud.position.HudSize;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.screen.ScreenContext;
import net.labymod.api.client.gui.screen.key.Key;
import net.labymod.api.client.gui.screen.widget.widgets.input.SwitchWidget;
import net.labymod.api.client.render.RenderPipeline;
import net.labymod.api.client.render.font.FontSize;
import net.labymod.api.client.render.font.RenderableComponent;
import net.labymod.api.client.render.matrix.Stack;
import net.labymod.api.client.session.Session;
import net.labymod.api.configuration.loader.annotation.SpriteSlot;
import net.labymod.api.configuration.loader.property.ConfigProperty;
import net.labymod.api.util.TextFormat;
import net.labymod.api.util.TimeUnit;
import net.labymod.api.util.bounds.area.RectangleAreaPosition;
import net.labymod.api.util.time.TimeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SpriteSlot(x=1, y=0)
public class VoiceChatIndicatorHudWidget
extends SimpleHudWidget<VoiceChatIndicatorHudWidgetConfig> {
    private final VoiceChat voiceChat;
    private final RenderPipeline renderPipeline;
    private final VoiceUserRegistry voiceUserRegistry;

    public VoiceChatIndicatorHudWidget(VoiceChat voiceChat) {
        super("voicechat_indicator", VoiceChatIndicatorHudWidgetConfig.class);
        this.voiceChat = voiceChat;
        this.renderPipeline = this.labyAPI.renderPipeline();
        this.voiceUserRegistry = voiceChat.referenceStorage().voiceUserRegistry();
    }

    public void initializePreConfigured(VoiceChatIndicatorHudWidgetConfig config) {
        super.initializePreConfigured((HudWidgetConfig)config);
        config.setEnabled(true);
        config.setX(0.0f);
        config.setY(-50.0f);
        config.setAreaIdentifier(RectangleAreaPosition.BOTTOM_CENTER);
    }

    public void render(SimpleHudWidget.RenderPhase phase, ScreenContext context, boolean isEditorContext, HudSize size) {
        Stack stack = context.stack();
        int iconSize = 18;
        float y = this.anchor.isCenter() ? (float)iconSize : (float)iconSize / 2.0f - 4.0f;
        float maxWidth = iconSize;
        if (((Boolean)((VoiceChatIndicatorHudWidgetConfig)this.config).showText().get()).booleanValue()) {
            ClientVoiceState state = this.voiceChat.clientVoiceState();
            if (isEditorContext) {
                state = ClientVoiceState.INPUT_MUTED;
            }
            RenderableComponent statusComponent = this.getStatusComponent(state);
            RenderableComponent detailComponent = this.getDetailComponent(state);
            RenderableComponent hintComponent = this.getHintComponent(state);
            float guiScale = this.labyAPI.minecraft().minecraftWindow().getScale();
            float hintScale = guiScale == 0.0f ? 1.0f : FontSize.PredefinedFontSize.SMALL.value((int)guiScale);
            maxWidth = Math.max(maxWidth, statusComponent.getWidth());
            if (detailComponent != null) {
                maxWidth = Math.max(maxWidth, detailComponent.getWidth());
            }
            if (hintComponent != null) {
                maxWidth = Math.max(maxWidth, hintComponent.getWidth() * hintScale);
            }
            if (!this.anchor.isCenter()) {
                maxWidth += (float)iconSize;
            }
            if (phase.canRender()) {
                context.canvas().submitRenderableComponent(statusComponent, this.anchor.isLeft() ? (float)(iconSize + 2) : (this.anchor.isCenter() ? maxWidth / 2.0f : maxWidth - statusComponent.getWidth() - (float)iconSize - 2.0f), y, -1, 1 | (this.anchor.isCenter() ? 2 : 0));
            }
            y += statusComponent.getHeight();
            if (detailComponent != null) {
                if (phase.canRender()) {
                    context.canvas().submitRenderableComponent(detailComponent, this.anchor.isLeft() ? (float)(iconSize + 2) : (this.anchor.isCenter() ? maxWidth / 2.0f : maxWidth - detailComponent.getWidth() - (float)iconSize - 2.0f), y, -1, 1 | (this.anchor.isCenter() ? 2 : 0));
                }
                y += detailComponent.getHeight();
            }
            if (hintComponent != null) {
                if (phase.canRender()) {
                    context.canvas().submitRenderableComponent(hintComponent, this.anchor.isLeft() ? (float)(iconSize + 2) : (this.anchor.isCenter() ? maxWidth / 2.0f : maxWidth - hintComponent.getWidth() * hintScale - (float)iconSize - 2.0f), y, -1, hintScale, 1 | (this.anchor.isCenter() ? 2 : 0));
                }
                y += hintComponent.getHeight();
            }
        }
        if (!this.anchor.isCenter()) {
            y = Math.max((float)iconSize, y);
        }
        AudioStreamState streamState = isEditorContext ? AudioStreamState.INPUT_MUTED : VoiceChatAddon.INSTANCE.referenceStorage().audioStreamRegistry().getClientState(true);
        Icon icon = streamState.getIcon();
        if (phase.canRender()) {
            float x = this.anchor.isLeft() ? 2.0f : (this.anchor.isCenter() ? maxWidth / 2.0f + 2.0f - (float)iconSize / 2.0f : maxWidth - (float)iconSize + 2.0f);
            context.canvas().submitIcon(icon, x, 0.0f, (float)iconSize, (float)iconSize);
        }
        size.set(maxWidth, y);
    }

    @NotNull
    private RenderableComponent getStatusComponent(ClientVoiceState state) {
        TextComponent component = switch (state) {
            case ClientVoiceState.INPUT_MUTED_GLOBAL -> {
                VoiceUser user = this.voiceUserRegistry.get(this.labyAPI.getUniqueId());
                if (user != null && user.getMute().isActive()) {
                    Mute mute = user.getMute();
                    yield Component.translatable((String)("voicechat.overlay.status." + (mute.isServerApiMute() ? "mutedServerApiReason" : "mutedReason")), (TextColor)NamedTextColor.DARK_RED).arguments(new Component[]{Component.text((String)("\"" + mute.getReason() + "\""))});
                }
                yield Component.empty();
            }
            case ClientVoiceState.NOT_CONNECTED -> {
                String message = this.voiceChat.referenceStorage().voiceChatClientListener().getLastDisconnectMessage();
                if (message != null) {
                    yield Component.translatable((String)"voicechat.overlay.status.notConnectedReason", (TextColor)NamedTextColor.RED).arguments(new Component[]{Component.text((String)message)});
                }
                yield Component.empty();
            }
            default -> (TranslatableComponent)Component.translatable((String)("voicechat.overlay.status." + TextFormat.SNAKE_CASE.toLowerCamelCase(state.name())), (Component[])new Component[0]).color(NamedTextColor.RED);
        };
        return RenderableComponent.of((Component)component);
    }

    @Nullable
    private RenderableComponent getDetailComponent(ClientVoiceState state) {
        TranslatableComponent component = switch (state) {
            case ClientVoiceState.INPUT_MUTED_GLOBAL -> {
                VoiceUser user = this.voiceUserRegistry.get(this.labyAPI.getUniqueId());
                if (user != null && user.getMute().isActive()) {
                    Mute mute = user.getMute();
                    long duration = mute.getTimeEnd() - TimeUtil.getCurrentTimeMillis();
                    if (mute.isPermanent()) {
                        yield Component.translatable((String)"voicechat.overlay.status.mutedPermanent", (Component[])new Component[0]).color(NamedTextColor.YELLOW);
                    }
                    yield Component.translatable((String)"voicechat.overlay.status.mutedTimer", (TextColor)NamedTextColor.YELLOW).arguments(new Component[]{Component.text((String)TimeUnit.parseToString((long)duration))});
                }
                yield null;
            }
            case ClientVoiceState.NOT_CONNECTED -> {
                long reconnectDuration = ((VoiceChatAddon)this.voiceChat).getTickListener().getReconnectDuration();
                yield Component.translatable((String)"voicechat.overlay.status.notConnectedTimer", (TextColor)NamedTextColor.YELLOW).arguments(new Component[]{Component.text((String)TimeUnit.parseToString((long)reconnectDuration))});
            }
            case ClientVoiceState.WRONG_SESSION -> {
                Minecraft minecraft = this.labyAPI.minecraft();
                Session voiceSession = this.voiceChat.client().getSession();
                String loggedInUsername = voiceSession == null ? "Unknown" : voiceSession.getUsername();
                ClientPlayer clientPlayer = minecraft.getClientPlayer();
                String serverUsername = clientPlayer == null ? "Unknown" : clientPlayer.profile().getUsername();
                yield Component.translatable((String)"voicechat.overlay.status.wrongSessionDetail", (TextColor)NamedTextColor.YELLOW).arguments(new Component[]{Component.text((String)loggedInUsername, (TextColor)NamedTextColor.WHITE), Component.text((String)serverUsername, (TextColor)NamedTextColor.WHITE)});
            }
            default -> null;
        };
        return component == null ? null : RenderableComponent.of(component);
    }

    @Nullable
    private RenderableComponent getHintComponent(ClientVoiceState state) {
        TranslatableComponent component = switch (state) {
            case ClientVoiceState.INPUT_MUTED_GLOBAL -> Component.translatable((String)"voicechat.overlay.status.mutedNote", (TextColor)NamedTextColor.GRAY);
            default -> null;
        };
        return component == null ? null : RenderableComponent.of((Component)component);
    }

    public boolean isVisibleInGame() {
        ClientVoiceState state = this.voiceChat.clientVoiceState();
        boolean voiceChatEnabled = (Boolean)this.voiceChat.configuration().enabled().get();
        if (!voiceChatEnabled) {
            return false;
        }
        boolean keyPressed = this.voiceChat.isPushToTalkPressed() || ((Key)this.voiceChat.configuration().voiceChannelsKey().get()).isPressed();
        return keyPressed && this.shouldShowStateWhenTalking(state) || this.shouldShowState(state);
    }

    private boolean shouldShowState(ClientVoiceState state) {
        return state == ClientVoiceState.INPUT_DISABLED || state == ClientVoiceState.OUTPUT_DISABLED || state == ClientVoiceState.INPUT_MUTED || state == ClientVoiceState.OUTPUT_MUTED;
    }

    private boolean shouldShowStateWhenTalking(ClientVoiceState state) {
        return state != ClientVoiceState.READY;
    }

    public static class VoiceChatIndicatorHudWidgetConfig
    extends HudWidgetConfig {
        @SwitchWidget.SwitchSetting
        private final ConfigProperty<Boolean> showText = new ConfigProperty((Object)true);

        public ConfigProperty<Boolean> showText() {
            return this.showText;
        }
    }
}

