/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.openal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.labymod.addons.voicechat.api.audio.device.AbstractAudioInterface;
import net.labymod.addons.voicechat.api.audio.device.Device;
import net.labymod.addons.voicechat.api.audio.device.DeviceInformation;
import net.labymod.addons.voicechat.api.audio.device.util.DeviceType;
import net.labymod.addons.voicechat.api.audio.device.util.Format;
import net.labymod.addons.voicechat.openal.OpenALInputDevice;
import net.labymod.addons.voicechat.openal.OpenALOutputDevice;
import net.labymod.addons.voicechat.openal.api.ALCapture;
import net.labymod.addons.voicechat.openal.api.ALSpeaker;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;

public class OpenALAudioInterface
extends AbstractAudioInterface {
    @Override
    public Component getDisplayName() {
        return Component.text((String)"OpenAL", (TextColor)NamedTextColor.AQUA);
    }

    @Override
    public String getIdentifier() {
        return "openal";
    }

    @Override
    public Device createDevice(DeviceInformation information) {
        return switch (information.getType()) {
            default -> throw new MatchException(null, null);
            case DeviceType.INPUT -> new OpenALInputDevice(information);
            case DeviceType.OUTPUT -> new OpenALOutputDevice(information);
        };
    }

    @Override
    protected Collection<DeviceInformation> fetchAvailableDevices(DeviceType deviceType, Format format) {
        ArrayList<DeviceInformation> list = new ArrayList<DeviceInformation>();
        if (deviceType == DeviceType.INPUT) {
            List<String> devices = ALCapture.getAvailableNames();
            for (String name : devices) {
                list.add(new DeviceInformation(this, name, this.formatDisplayName(name), deviceType, format));
            }
        }
        if (deviceType == DeviceType.OUTPUT) {
            List<String> names = ALSpeaker.getAvailableNames();
            for (String name : names) {
                list.add(new DeviceInformation(this, name, this.formatDisplayName(name), deviceType, format));
            }
        }
        return list;
    }

    @Override
    public DeviceInformation getDefaultInputDevice(Format format) {
        String defaultName = ALCapture.getDefaultName();
        return new DeviceInformation(this, defaultName, this.formatDisplayName(defaultName), DeviceType.INPUT, format);
    }

    @Override
    public DeviceInformation getDefaultOutputDevice(Format format) {
        String defaultName = ALSpeaker.getDefaultName();
        return new DeviceInformation(this, defaultName, this.formatDisplayName(defaultName), DeviceType.OUTPUT, format);
    }

    private String formatDisplayName(String displayName) {
        return displayName.replaceAll("OpenAL Soft on ", "");
    }
}

