/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.openal.api;

import net.labymod.addons.voicechat.api.audio.device.util.ChannelType;
import net.labymod.addons.voicechat.openal.api.ALBuffer;
import net.labymod.addons.voicechat.openal.api.ALSource;
import net.labymod.api.util.math.vector.DoubleVector3;
import net.labymod.api.util.math.vector.FloatVector3;

public class ALBufferedSource {
    private final int sampleRate;
    private final int bufferSize;
    private final int flushLoops;
    private final ChannelType channelType;
    private final ALSource source;
    private final ALBuffer buffer;
    private int bufferIndex = 0;
    private boolean dirty;

    public ALBufferedSource(int sampleRate, int bufferSize, int buffers, int flushLoops, ChannelType type) {
        this.sampleRate = sampleRate;
        this.bufferSize = bufferSize;
        this.flushLoops = flushLoops;
        this.channelType = type;
        this.source = new ALSource();
        this.source.setLooping(false);
        this.source.setDistanceModel(ALSource.DistanceModel.INVERSE_CLAMPED);
        this.buffer = new ALBuffer(buffers);
    }

    public void setPosition(DoubleVector3 position) {
        this.source.setPosition((float)position.getX(), (float)position.getY(), (float)position.getZ());
    }

    public void setListenerPosition(DoubleVector3 position) {
        this.source.setListenerPosition((float)position.getX(), (float)position.getY(), (float)position.getZ());
    }

    public void setListenerOrientation(FloatVector3 direction) {
        this.source.setListenerOrientation(direction.getX(), direction.getY(), direction.getZ(), 0.0f, 1.0f, 0.0f);
    }

    public void write(ChannelType type, short[] samples, int offset, int length) {
        if (type != this.channelType) {
            throw new IllegalArgumentException("Channel type mismatch: got " + String.valueOf((Object)type) + " but expected " + String.valueOf((Object)this.channelType));
        }
        this.unqueueProcessedBuffers();
        boolean idle = this.isIdle();
        if (idle) {
            this.flush();
        }
        this.write0(type, samples, offset, length);
        this.dirty = true;
        if (idle) {
            this.source.play();
        }
    }

    private void write0(ChannelType type, short[] samples, int offset, int length) {
        int queued = this.source.getQueuedBuffers();
        if (queued >= this.buffer.getSize()) {
            int sampleOffset = this.source.getSampleOffset();
            int buffersToSkip = queued - this.flushLoops;
            this.source.setSampleOffset(sampleOffset + buffersToSkip * this.bufferSize);
            this.unqueueProcessedBuffers();
        }
        if (samples.length > length) {
            short[] newSamples = new short[length];
            System.arraycopy(samples, 0, newSamples, 0, length);
            samples = newSamples;
        }
        ALBuffer.FormatType format = ALBuffer.FormatType.fromChannels(type.getChannels(), 16);
        this.buffer.write(this.bufferIndex, format, samples, this.sampleRate);
        this.source.queueBuffer(this.buffer, this.bufferIndex);
        this.bufferIndex = (this.bufferIndex + 1) % this.buffer.getSize();
    }

    public void unqueueProcessedBuffers() {
        int processed = this.source.getProcessedBuffers();
        for (int i = 0; i < processed; ++i) {
            this.source.unqueueBuffer();
        }
    }

    public void flush() {
        for (int i = 0; i < this.flushLoops; ++i) {
            this.write0(this.channelType, new short[this.bufferSize], 0, this.bufferSize);
        }
    }

    public boolean isIdle() {
        ALSource.State state = this.source.getState();
        int queued = this.source.getQueuedBuffers();
        return state == ALSource.State.INITIAL || state == ALSource.State.STOPPED || state == ALSource.State.PAUSED || queued <= 0;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void resetDirty() {
        this.dirty = false;
    }

    public boolean isWriteable() {
        return this.source.getQueuedBuffers() < this.buffer.getSize();
    }

    public ALSource source() {
        return this.source;
    }

    public ALBuffer buffer() {
        return this.buffer;
    }

    public boolean exists() {
        return this.source.exists();
    }

    public void delete() {
        this.unqueueProcessedBuffers();
        this.source.delete();
    }
}

