/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.openal.api;

import java.util.Collections;
import java.util.List;
import net.labymod.addons.voicechat.api.audio.device.util.Format;
import net.labymod.addons.voicechat.openal.api.ALDevice;
import net.labymod.addons.voicechat.openal.api.ALError;
import org.lwjgl.openal.ALC11;
import org.lwjgl.openal.ALUtil;

public class ALCapture
extends ALDevice {
    private boolean active;

    public boolean open(String name, Format format, int bufferSize) {
        this.id = ALC11.alcCaptureOpenDevice((CharSequence)name, (int)format.getSampleRate(), (int)65552, (int)bufferSize);
        ALError.checkALC(this.id);
        return this.id != 0L;
    }

    public void start() {
        ALC11.alcCaptureStart((long)this.id);
        ALError.checkALC(this.id);
        this.active = true;
    }

    public int available() {
        int samples = ALC11.alcGetInteger((long)this.id, (int)786);
        ALError.checkALC(this.id);
        return samples;
    }

    public void read(float[] buffer, int samples) {
        ALC11.alcCaptureSamples((long)this.id, (float[])buffer, (int)samples);
        ALError.checkALC(this.id);
    }

    public void stop() {
        ALC11.alcCaptureStop((long)this.id);
        ALError.checkALC(this.id);
        this.active = false;
    }

    public void close() {
        ALC11.alcCaptureCloseDevice((long)this.id);
        ALError.checkALC(this.id);
        this.id = 0L;
    }

    public boolean isActive() {
        return this.active;
    }

    public static String getDefaultName() {
        String name = ALC11.alcGetString((long)0L, (int)785);
        ALError.checkALC(0L);
        return name;
    }

    public static List<String> getAvailableNames() {
        List<String> devices = ALUtil.getStringList((long)0L, (int)784);
        ALError.checkALC(0L);
        return devices != null ? devices : Collections.emptyList();
    }
}

