/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.voice.protocol.packet.server.world;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.labymod.voice.protocol.VoicePacket;
import net.labymod.voice.protocol.handler.ServerVoicePacketHandler;
import net.labymod.voice.protocol.type.ConnectionState;
import net.labymod.voice.protocol.type.EncryptType;

public class PlayerAlivePacket
extends VoicePacket<ServerVoicePacketHandler> {
    private final List<UUID> uniqueIds = new ArrayList<UUID>();
    private final Map<UUID, JsonObject> meta = new HashMap<UUID, JsonObject>();

    public PlayerAlivePacket() {
        super(EncryptType.SYM, ConnectionState.CONNECTED);
    }

    public void add(UUID uniqueId, JsonObject meta) {
        this.uniqueIds.add(uniqueId);
        if (meta != null) {
            this.meta.put(uniqueId, meta);
        }
    }

    @Override
    public void write(ByteArrayOutputStream buffer, int protocolVersion) throws IOException {
        buffer.write(this.uniqueIds.size());
        for (UUID uUID : this.uniqueIds) {
            PlayerAlivePacket.writeUUID(uUID, buffer);
        }
        if (protocolVersion == 3) {
            buffer.write(this.uniqueIds.size());
            for (UUID uUID : this.uniqueIds) {
                JsonObject json = this.meta.get(uUID);
                VoicePacket.writeJson((JsonElement)(json == null ? new JsonObject() : json), buffer);
            }
        }
        if (protocolVersion >= 4) {
            buffer.write(this.meta.size());
            for (Map.Entry entry : this.meta.entrySet()) {
                PlayerAlivePacket.writeUUID((UUID)entry.getKey(), buffer);
                VoicePacket.writeJson((JsonElement)entry.getValue(), buffer);
            }
        }
    }

    @Override
    public void read(ByteArrayInputStream buffer, int protocolVersion) throws IOException {
        int playerCount = buffer.read();
        for (int i = 0; i < playerCount; ++i) {
            this.uniqueIds.add(PlayerAlivePacket.readUUID(buffer));
        }
        int metaCount = buffer.read();
        for (int i = 0; i < metaCount; ++i) {
            this.meta.put(PlayerAlivePacket.readUUID(buffer), VoicePacket.readJson(buffer).getAsJsonObject());
        }
    }

    @Override
    public void handle(ServerVoicePacketHandler handler) {
        handler.handlePlayerAlive(this);
    }

    public Collection<UUID> getUniqueIds() {
        return this.uniqueIds;
    }

    public boolean hasUniqueIds() {
        return !this.uniqueIds.isEmpty();
    }

    public boolean isFull() {
        return this.uniqueIds.size() >= 50;
    }

    public JsonObject getMeta(UUID uniqueId) {
        return this.meta.get(uniqueId);
    }
}

