/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.api.audio.device;

import java.io.IOException;
import java.util.Collection;
import net.labymod.addons.voicechat.api.audio.device.AudioInterface;
import net.labymod.addons.voicechat.api.audio.device.Device;
import net.labymod.addons.voicechat.api.audio.device.DeviceInformation;
import net.labymod.addons.voicechat.api.audio.device.io.InputDevice;
import net.labymod.addons.voicechat.api.audio.device.io.OutputDevice;
import net.labymod.addons.voicechat.api.audio.device.util.DeviceType;
import net.labymod.api.reference.annotation.Referenceable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Referenceable
public interface DeviceController {
    public void registerAudioInterface(@NotNull AudioInterface var1);

    default public void updateDevices() {
        this.updateInputDevices();
        this.updateOutputDevices();
    }

    public void updateInputDevices();

    public void updateOutputDevices();

    @NotNull
    public Collection<DeviceInformation> getDevices(DeviceType var1);

    public boolean isInputDeviceRunning();

    public boolean isOutputDeviceRunning();

    @Nullable
    public InputDevice getSelectedInputDevice();

    @Nullable
    public OutputDevice getSelectedOutputDevice();

    public DeviceInformation getDefaultInputDevice();

    public DeviceInformation getDefaultOutputDevice();

    public void setSelectedInputDevice(@Nullable InputDevice var1) throws IOException;

    public void setSelectedOutputDevice(@Nullable OutputDevice var1) throws IOException;

    public DeviceInformation getDeviceByIdentifier(DeviceType var1, String var2);

    public Collection<AudioInterface> getAudioInterfaces();

    @Nullable
    public AudioInterface getAudioInterface(String var1);

    default public void setSelectedDeviceByIdentifier(DeviceType type, String identifier) throws IOException {
        DeviceInformation information = this.getDeviceByIdentifier(type, identifier);
        if (information == null) {
            throw new IllegalArgumentException("Device with identifier " + identifier + " not found");
        }
        if (information.getType() != type) {
            throw new IllegalArgumentException("Device with identifier " + identifier + " is not an " + type.name() + " device");
        }
        Device currentDevice = this.getSelectedDevice(type);
        if (currentDevice != null && currentDevice.information().equals(information)) {
            return;
        }
        this.setSelectedDevice(information.create());
    }

    @NotNull
    default public Collection<DeviceInformation> getInputDevices() {
        return this.getDevices(DeviceType.INPUT);
    }

    @NotNull
    default public Collection<DeviceInformation> getOutputDevices() {
        return this.getDevices(DeviceType.OUTPUT);
    }

    @Nullable
    default public Device getSelectedDevice(DeviceType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case DeviceType.INPUT -> this.getSelectedInputDevice();
            case DeviceType.OUTPUT -> this.getSelectedOutputDevice();
        };
    }

    default public void setSelectedDevice(@NotNull Device device) throws IOException {
        switch (device.information().getType()) {
            case INPUT: {
                this.setSelectedInputDevice((InputDevice)device);
                break;
            }
            case OUTPUT: {
                this.setSelectedOutputDevice((OutputDevice)device);
            }
        }
    }

    default public void updateDevice(DeviceType type) {
        switch (type) {
            case INPUT: {
                this.updateInputDevices();
                break;
            }
            case OUTPUT: {
                this.updateOutputDevices();
            }
        }
    }

    default public DeviceInformation getDefaultDevice(DeviceType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case DeviceType.INPUT -> this.getDefaultInputDevice();
            case DeviceType.OUTPUT -> this.getDefaultOutputDevice();
        };
    }
}

