/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.api.audio.util;

public final class Sample {
    public static final float MAX_SAMPLE = 32768.0f;

    public static boolean isDecibelAbove(short[] samples, double decibel) {
        for (int i = 0; i < samples.length; i += 100) {
            double currentDecibel = Sample.getDecibel(samples, i, Math.min(i + 100, samples.length));
            if (!(currentDecibel >= decibel)) continue;
            return true;
        }
        return false;
    }

    public static double getDecibel(short[] samples, int offset, int length) {
        if (length <= 0) {
            return -127.0;
        }
        double rms = 0.0;
        for (int i = offset; i < length; ++i) {
            double sample = (double)samples[i] / 32767.0;
            rms += sample * sample;
        }
        if ((rms = Math.sqrt(rms / (double)length)) <= 0.0) {
            return -127.0;
        }
        return Math.min(Math.max(20.0 * Math.log10(rms), -127.0), 0.0);
    }

    public static double decibelToPercentage(double decibel) {
        return (decibel + 127.0) / 127.0;
    }

    public static double percentageToDecibel(double percentage) {
        return percentage * 127.0 - 127.0;
    }

    public static double sliderToDecibel(double value) {
        if (value == 0.0) {
            return -127.0;
        }
        return (value - 1.0) * 30.0;
    }

    public static double decibelToSlider(double decibel) {
        if (decibel <= -30.0) {
            return 0.0;
        }
        return decibel / 30.0 + 1.0;
    }

    public static double gainToDecibel(double gain) {
        if (gain < 0.0) {
            throw new IllegalArgumentException("Gain must be greater than 0");
        }
        return 20.0 * Math.log10(gain);
    }

    public static double decibelToGain(double decibel) {
        if (decibel < -127.0) {
            decibel = -127.0;
        }
        if (decibel > 32.0) {
            decibel = 32.0;
        }
        return Math.pow(10.0, decibel > 1.0 ? decibel / 20.0 : decibel / 10.0);
    }

    public static void swap(short[] samples1, short[] samples2) {
        for (int i = 0; i < samples1.length; ++i) {
            short temp = samples2[i];
            samples2[i] = samples1[i];
            samples1[i] = temp;
        }
    }
}

