/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.api.client.user.moderate;

import java.util.Locale;
import net.labymod.api.util.I18n;

public enum MuteTemplate {
    BEHAVIOR,
    SOUNDBOARD,
    VOLUME,
    RACISM,
    HARASSMENT,
    CUSTOM;


    public String getIdentifier() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public String getDisplayName() {
        String key = "voicechat.activity.template.%s".formatted(this.getIdentifier());
        return I18n.translate((String)key, (Object[])new Object[0]);
    }

    public static MuteTemplate fromDisplayName(String displayName) {
        for (MuteTemplate template : MuteTemplate.values()) {
            if (!template.getDisplayName().equals(displayName)) continue;
            return template;
        }
        return null;
    }

    public static MuteTemplate fromIdentifier(String identifier) {
        for (MuteTemplate template : MuteTemplate.values()) {
            if (!template.getIdentifier().equals(identifier)) continue;
            return template;
        }
        return null;
    }

    public static String prettify(String reason) {
        if (reason == null) {
            return "Unknown";
        }
        MuteTemplate template = MuteTemplate.fromIdentifier(reason);
        if (template != null) {
            return template.getDisplayName();
        }
        template = MuteTemplate.fromDisplayName(reason);
        if (template != null) {
            return template.getDisplayName();
        }
        return reason;
    }
}

