/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.audio.device.task;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.labymod.addons.voicechat.api.audio.device.util.DeviceType;
import net.labymod.addons.voicechat.api.event.task.AudioTaskStateChangedEvent;
import net.labymod.api.Laby;
import net.labymod.api.event.Event;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.client.lifecycle.GameShutdownEvent;
import net.labymod.api.util.logging.Logging;

public abstract class AbstractAudioTask {
    protected final Logging logging = Logging.getLogger();
    protected final ExecutorService executor = Executors.newSingleThreadExecutor(factory -> {
        Thread thread = new Thread(factory);
        thread.setName(this.getTaskName());
        thread.setDaemon(true);
        return thread;
    });
    protected final Queue<Runnable> taskQueue = new ConcurrentLinkedQueue<Runnable>();
    protected final DeviceType type;
    protected Future<?> future;

    public AbstractAudioTask(DeviceType type) {
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        AbstractAudioTask abstractAudioTask = this;
        synchronized (abstractAudioTask) {
            if (this.isRunning()) {
                return;
            }
            this.stop();
            this.future = this.executor.submit(() -> {
                try {
                    Laby.fireEvent((Event)new AudioTaskStateChangedEvent(this.type, true));
                    while (this.isRunning()) {
                        this.process0();
                    }
                    this.close();
                    this.logging.info((CharSequence)"Audio task stopped", new Object[0]);
                }
                catch (Throwable e) {
                    this.logging.error((CharSequence)"An error occurred while processing audio task", e);
                    this.close();
                }
            });
        }
    }

    private void process0() {
        long interval = this.getProcessIntervalMs();
        this.ensureInterval(interval, () -> {
            Runnable task;
            while ((task = this.taskQueue.poll()) != null) {
                task.run();
            }
            this.process();
        });
    }

    @Subscribe
    public void onGameShutdown(GameShutdownEvent event) {
        this.scheduleTask(this::close);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        AbstractAudioTask abstractAudioTask = this;
        synchronized (abstractAudioTask) {
            if (this.future != null) {
                this.future.cancel(true);
            }
        }
    }

    public void close() {
        Laby.fireEvent((Event)new AudioTaskStateChangedEvent(this.type, false));
    }

    public boolean isRunning() {
        return this.future != null && !this.future.isDone();
    }

    protected abstract void process();

    public abstract long getProcessIntervalMs();

    public abstract String getTaskName();

    public void scheduleTask(Runnable task) {
        this.taskQueue.add(task);
    }

    private void ensureInterval(long ms, Runnable runnable) {
        long start = System.nanoTime();
        runnable.run();
        try {
            long nanoToSleep = ms * 1000000L - (System.nanoTime() - start);
            long msToSleep = nanoToSleep / 1000000L;
            if (nanoToSleep > 0L) {
                Thread.sleep(msToSleep, (int)(nanoToSleep % 1000000L));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

