/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.audio.stream.user.player.effect;

import java.util.ArrayList;
import java.util.List;
import net.labymod.addons.voicechat.api.audio.stream.user.player.effect.AudioPostProcessor;
import net.labymod.addons.voicechat.core.audio.stream.user.player.effect.AudioFilter;

public class FilterAudioPostProcessor
implements AudioPostProcessor {
    private final List<AudioFilter> filters = new ArrayList<AudioFilter>();

    public void register(AudioFilter filter) {
        this.filters.add(filter);
    }

    @Override
    public void process(short[] samples, int offset, int length) {
        for (AudioFilter filter : this.filters) {
            if (!filter.isActive()) continue;
            filter.preProcess(samples, offset, length);
        }
        for (AudioFilter filter : this.filters) {
            if (!filter.isActive()) continue;
            filter.postProcess(samples, offset, length);
        }
    }

    @Override
    public void readStereoOverlay(short[] out, int offset, int length) {
        for (AudioFilter filter : this.filters) {
            if (!filter.hasStereo() || !filter.isActive()) continue;
            filter.readStereoOverlay(out, offset, length);
        }
    }

    @Override
    public boolean canClose() {
        for (AudioFilter filter : this.filters) {
            if (filter.canClose() || !filter.isActive()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasStereo() {
        for (AudioFilter filter : this.filters) {
            if (!filter.hasStereo()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        for (AudioFilter filter : this.filters) {
            filter.close();
        }
    }
}

