/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.audio.stream.user.player.effect;

import net.labymod.addons.voicechat.api.client.user.VoiceUser;
import net.labymod.addons.voicechat.core.VoiceChatAddon;
import net.labymod.addons.voicechat.core.audio.stream.user.player.effect.FilterAudioPostProcessor;
import net.labymod.addons.voicechat.core.audio.stream.user.player.effect.filter.ClippingDistortionAudioFilter;
import net.labymod.addons.voicechat.core.audio.stream.user.player.effect.filter.CompressionAudioFilter;
import net.labymod.addons.voicechat.core.audio.stream.user.player.effect.filter.CompressorAudioFilter;
import net.labymod.addons.voicechat.core.audio.stream.user.player.effect.filter.HighPassAudioFilter;
import net.labymod.addons.voicechat.core.audio.stream.user.player.effect.filter.NoiseAudioFilter;
import net.labymod.addons.voicechat.core.audio.stream.user.player.effect.filter.RogerBeepAudioFilter;
import net.labymod.addons.voicechat.core.configuration.DefaultVoiceChatConfiguration;

public class UserAudioPostProcessor
extends FilterAudioPostProcessor {
    private final VoiceUser user;
    private final CompressorAudioFilter compressorAudioFilter;
    private final HighPassAudioFilter highPassAudioFilter;
    private final ClippingDistortionAudioFilter clippingDistortionAudioFilter;
    private final CompressionAudioFilter compressionAudioFilter;
    private final NoiseAudioFilter noiseAudioFilter;
    private final RogerBeepAudioFilter rogerBeepAudioFilter;
    private final DefaultVoiceChatConfiguration config;

    public UserAudioPostProcessor(VoiceUser user) {
        this.user = user;
        this.highPassAudioFilter = new HighPassAudioFilter();
        this.register(this.highPassAudioFilter);
        this.clippingDistortionAudioFilter = new ClippingDistortionAudioFilter();
        this.register(this.clippingDistortionAudioFilter);
        this.compressionAudioFilter = new CompressionAudioFilter();
        this.register(this.compressionAudioFilter);
        this.noiseAudioFilter = new NoiseAudioFilter();
        this.register(this.noiseAudioFilter);
        this.rogerBeepAudioFilter = new RogerBeepAudioFilter();
        this.register(this.rogerBeepAudioFilter);
        this.compressorAudioFilter = new CompressorAudioFilter();
        this.register(this.compressorAudioFilter);
        this.config = (DefaultVoiceChatConfiguration)VoiceChatAddon.INSTANCE.configuration();
    }

    @Override
    public void tick() {
        super.tick();
        boolean compressorActive = (Boolean)this.config.volumeCompressor().get();
        float gain = ((Float)this.config.outputVolume().get()).floatValue();
        this.compressorAudioFilter.setActive(compressorActive);
        this.compressorAudioFilter.setGain(gain);
        if (this.user.hasWalkieTalkieFilter()) {
            this.highPassAudioFilter.setOpacity(1.0f);
            this.clippingDistortionAudioFilter.setActive(true);
            this.clippingDistortionAudioFilter.setThreshold((short)100);
            this.compressionAudioFilter.setActive(true);
            this.compressionAudioFilter.setThreshold(0.5f);
            this.compressionAudioFilter.setRatio(4.0);
            this.noiseAudioFilter.setActive(true);
            this.noiseAudioFilter.setNoiseLevel(this.rogerBeepAudioFilter.isPlayingBeep() ? 0.0f : 10.0f);
            this.rogerBeepAudioFilter.setActive(true);
            this.rogerBeepAudioFilter.setVolume((short)(40.0f * gain));
        } else {
            this.highPassAudioFilter.setOpacity(0.0f);
            this.clippingDistortionAudioFilter.setActive(false);
            this.compressionAudioFilter.setActive(false);
            this.noiseAudioFilter.setActive(false);
            this.rogerBeepAudioFilter.setActive(false);
        }
    }
}

