/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.audio.stream.user.player.effect.filter;

import net.labymod.addons.voicechat.api.audio.util.Sample;
import net.labymod.addons.voicechat.core.audio.stream.user.player.effect.AbstractAudioFilter;
import net.labymod.api.util.math.MathHelper;

public class CompressorAudioFilter
extends AbstractAudioFilter {
    private boolean active;
    private double gain;
    private double avg = 0.0;
    private double count = 0.0;

    @Override
    public void postProcess(short[] samples, int offset, int length) {
        super.postProcess(samples, offset, length);
        double decibel = Sample.getDecibel(samples, offset, length);
        double gain = Sample.decibelToGain(MathHelper.clamp((double)(decibel + 30.0), (double)-127.0, (double)32.0));
        double modifier = MathHelper.clamp((double)(this.gain / gain), (double)0.0, (double)1.0);
        for (int i = offset; i < length; ++i) {
            double sample = samples[i];
            this.avg += modifier;
            this.count += 1.0;
            double avgModifier = this.avg / (this.count + 1.0);
            samples[i] = (short)(sample * avgModifier);
            if (modifier != 1.0) continue;
            this.avg *= 0.998;
            this.count *= 0.998;
        }
    }

    @Override
    public void reset() {
        this.avg = 0.0;
        this.count = 0.0;
    }

    @Override
    public boolean canClose() {
        return true;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void setGain(double gain) {
        this.gain = gain;
    }
}

