/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.client;

import java.net.InetSocketAddress;
import java.util.concurrent.Executors;
import javax.inject.Singleton;
import net.labymod.addons.voicechat.api.VoiceChat;
import net.labymod.addons.voicechat.api.client.VoiceChatClientListener;
import net.labymod.addons.voicechat.api.client.VoiceConnector;
import net.labymod.addons.voicechat.api.client.transmitter.VoiceTransmitter;
import net.labymod.addons.voicechat.api.configuration.VoiceChatConfiguration;
import net.labymod.addons.voicechat.core.client.transmitter.DefaultVoiceTransmitter;
import net.labymod.api.Laby;
import net.labymod.api.client.session.Session;
import net.labymod.api.models.Implements;
import net.labymod.voice.client.VoiceClient;
import net.labymod.voice.client.auth.AuthenticationResponse;
import net.labymod.voice.protocol.type.AuthenticationMethod;
import org.jetbrains.annotations.Nullable;

@Singleton
@Implements(value=VoiceConnector.class)
public class DefaultVoiceConnector
implements VoiceConnector {
    private static final boolean LOCALHOST = false;
    private final VoiceChat voiceChat;
    private final VoiceClient voiceClient;
    private final VoiceTransmitter transmitter;
    private final VoiceChatClientListener listener;
    private Session session;

    public DefaultVoiceConnector(VoiceChat voiceChat, VoiceChatClientListener listener) {
        this.voiceChat = voiceChat;
        this.listener = listener;
        this.voiceClient = new VoiceClient();
        this.voiceClient.setListener(listener);
        this.transmitter = new DefaultVoiceTransmitter(voiceChat, this.voiceClient);
    }

    @Override
    public VoiceTransmitter transmitter() {
        return this.transmitter;
    }

    @Override
    public void switchSession(Session session) {
        this.session = session;
        this.voiceClient.setAuthenticator(AuthenticationMethod.MOJANG, hash -> {
            try {
                Laby.labyAPI().minecraft().authenticator().joinServer(session, hash).get();
                return AuthenticationResponse.createMojang(session.getUsername());
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        });
        if (this.isConnected()) {
            this.disconnect("Switching session");
            this.connect();
        }
    }

    @Override
    public void connect() {
        if (this.session == null || !this.session.isPremium()) {
            return;
        }
        Executors.newSingleThreadExecutor().execute(() -> {
            try {
                VoiceChatConfiguration configuration = this.voiceChat.configuration();
                boolean useBackupServer = (Boolean)configuration.useBackupServer().get();
                boolean useTestServer = (Boolean)configuration.useTestServer().get();
                String ip = !useTestServer && useBackupServer ? "voice2.labymod.net" : "voice.labymod.net";
                int port = useTestServer ? 8067 : 8066;
                InetSocketAddress address = new InetSocketAddress(ip, port);
                this.voiceClient.connect(address, AuthenticationMethod.MOJANG);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void disconnect(String reason) {
        if (this.voiceClient != null) {
            this.voiceClient.stop(reason);
        }
    }

    @Override
    public boolean isConnected() {
        return this.voiceClient.isConnected();
    }

    @Override
    public boolean isAuthenticated() {
        return this.listener.isAuthenticated();
    }

    @Override
    @Nullable
    public Session getSession() {
        return this.session;
    }

    @Override
    public boolean isStaff() {
        return this.voiceClient.isAdmin();
    }
}

