/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.client.user.moderate;

import java.util.Objects;
import java.util.UUID;
import net.labymod.addons.voicechat.api.client.user.moderate.MuteTemplate;
import net.labymod.addons.voicechat.api.client.user.moderate.Report;

public class DefaultReport
implements Report {
    private final int id;
    private final String reason;
    private final String reportedBy;
    private final long reportedAt;
    private final String serverAddress;
    private final UUID tapeId;

    public DefaultReport(int id, String reason, String reportedBy, long reportedAt, String serverAddress, UUID tapeId) {
        this.id = id;
        this.reason = reason;
        this.reportedBy = reportedBy;
        this.reportedAt = reportedAt;
        this.serverAddress = serverAddress;
        this.tapeId = tapeId;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getReason() {
        return MuteTemplate.prettify(this.reason);
    }

    @Override
    public String getReportedBy() {
        return this.reportedBy;
    }

    @Override
    public long getReportedAt() {
        return this.reportedAt;
    }

    @Override
    public String getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public UUID getTapeId() {
        return this.tapeId;
    }

    public String toString() {
        return this.getReason() + " by " + this.reportedBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultReport that = (DefaultReport)o;
        return Objects.equals(this.reason, that.reason) && Objects.equals(this.reportedBy, that.reportedBy);
    }

    public int hashCode() {
        return Objects.hash(this.reason, this.reportedBy);
    }
}

