/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.serverapi;

import net.labymod.addons.voicechat.api.client.user.VoiceUser;
import net.labymod.addons.voicechat.api.client.user.VoiceUserRegistry;
import net.labymod.addons.voicechat.core.VoiceChatAddon;
import net.labymod.addons.voicechat.core.serverapi.VoiceChatTranslationListener;
import net.labymod.addons.voicechat.core.serverapi.packet.model.ServerMute;
import net.labymod.addons.voicechat.core.ui.activity.channel.VoiceChannelsActivity;
import net.labymod.api.Laby;
import net.labymod.api.client.Minecraft;
import net.labymod.api.client.gui.screen.ScreenInstance;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.client.network.server.ServerDisconnectEvent;
import net.labymod.api.serverapi.LabyModProtocolService;
import net.labymod.api.serverapi.TranslationListener;
import net.labymod.api.serverapi.TranslationProtocol;
import net.labymod.serverapi.api.Protocol;
import net.labymod.serverapi.api.payload.PayloadChannelIdentifier;
import net.labymod.serverapi.core.AddonProtocol;
import net.labymod.serverapi.integration.voicechat.VoiceChatIntegration;
import net.labymod.serverapi.integration.voicechat.model.VoiceChatMute;
import net.labymod.serverapi.integration.voicechat.packets.VoiceChatMutePacket;
import net.labymod.serverapi.integration.voicechat.packets.VoiceChatOpenChannelsPacket;
import net.labymod.serverapi.integration.voicechat.packets.VoiceChatUnmutePacket;

public class VoiceChatServerApi {
    private static final PayloadChannelIdentifier LEGACY_ID = PayloadChannelIdentifier.create((String)"labymod3", (String)"main");
    private final VoiceUserRegistry userRegistry = VoiceChatAddon.INSTANCE.referenceStorage().voiceUserRegistry();

    public VoiceChatServerApi() {
        LabyModProtocolService protocolService = Laby.references().labyModProtocolService();
        VoiceChatIntegration voiceChatIntegration = (VoiceChatIntegration)protocolService.getOrRegisterIntegration(VoiceChatIntegration.class, VoiceChatIntegration::new);
        AddonProtocol addonProtocol = voiceChatIntegration.voiceChatProtocol();
        TranslationProtocol translationProtocol = new TranslationProtocol(LEGACY_ID, (Protocol)addonProtocol);
        translationProtocol.registerListener((TranslationListener)new VoiceChatTranslationListener(addonProtocol));
        protocolService.translationRegistry().register(translationProtocol);
        addonProtocol.registerHandler(VoiceChatMutePacket.class, (sender, packet) -> {
            for (VoiceChatMute mute : packet.getMutes()) {
                VoiceUser voiceUser = this.userRegistry().getOrCreate(mute.getUniqueId());
                voiceUser.setServerApiMute(new ServerMute(mute.isPermanent() ? Long.MAX_VALUE : mute.getEnd(), mute.getReason()));
            }
        });
        addonProtocol.registerHandler(VoiceChatUnmutePacket.class, (sender, packet) -> {
            VoiceUser voiceUser = this.userRegistry().getOrCreate(packet.getUniqueId());
            voiceUser.setServerApiMute(new ServerMute(0L, null));
        });
        addonProtocol.registerHandler(VoiceChatOpenChannelsPacket.class, (sender, packet) -> {
            Minecraft minecraft = Laby.labyAPI().minecraft();
            minecraft.executeNextTick(() -> minecraft.minecraftWindow().displayScreen((ScreenInstance)new VoiceChannelsActivity()));
        });
    }

    @Subscribe
    public void onServerDisconnect(ServerDisconnectEvent event) {
        for (VoiceUser voiceUser : this.userRegistry.getAll()) {
            voiceUser.resetServerProperties();
        }
    }

    public VoiceUserRegistry userRegistry() {
        return this.userRegistry;
    }
}

