/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.serverapi;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.labymod.api.serverapi.KeyedTranslationListener;
import net.labymod.api.serverapi.LabyModProtocolService;
import net.labymod.serverapi.api.packet.Packet;
import net.labymod.serverapi.core.AddonProtocol;
import net.labymod.serverapi.integration.voicechat.model.VoiceChatMute;
import net.labymod.serverapi.integration.voicechat.packets.VoiceChatMutePacket;
import net.labymod.serverapi.integration.voicechat.packets.VoiceChatOpenChannelsPacket;
import net.labymod.serverapi.integration.voicechat.packets.VoiceChatUnmutePacket;

public class VoiceChatTranslationListener
extends KeyedTranslationListener {
    private final AddonProtocol protocol;

    public VoiceChatTranslationListener(AddonProtocol protocol) {
        super("voicechat");
        this.protocol = protocol;
    }

    protected Packet translateIncomingMessage(JsonElement messageContent) {
        if (!messageContent.isJsonObject()) {
            return null;
        }
        JsonObject object = messageContent.getAsJsonObject();
        if (object.has("mute_player")) {
            boolean hasUnmutes;
            JsonElement mutePlayerElement = object.get("mute_player");
            ArrayList<VoiceChatMute> mutes = new ArrayList<VoiceChatMute>();
            ArrayList<UUID> unmutes = new ArrayList<UUID>();
            if (mutePlayerElement.isJsonArray()) {
                for (JsonElement jsonElement : mutePlayerElement.getAsJsonArray()) {
                    this.muteFromJsonElement(jsonElement, mutes, unmutes);
                }
            } else {
                this.muteFromJsonElement(mutePlayerElement, mutes, unmutes);
            }
            boolean hasMutes = !mutes.isEmpty();
            boolean bl = hasUnmutes = !unmutes.isEmpty();
            if (hasUnmutes) {
                VoiceChatUnmutePacket returnPacket = null;
                if (!hasMutes) {
                    returnPacket = new VoiceChatUnmutePacket((UUID)unmutes.removeFirst());
                }
                for (int i = 0; i < unmutes.size(); ++i) {
                    this.protocol.handlePacket(LabyModProtocolService.DUMMY_UUID, (Packet)new VoiceChatUnmutePacket((UUID)unmutes.get(i)));
                }
                if (returnPacket != null) {
                    return returnPacket;
                }
            }
            if (hasMutes) {
                return new VoiceChatMutePacket(mutes.toArray(new VoiceChatMute[0]));
            }
            return null;
        }
        if (object.has("open_voice_channels")) {
            return new VoiceChatOpenChannelsPacket();
        }
        return null;
    }

    protected JsonElement translateOutgoingMessage(Packet packet) {
        return null;
    }

    private void muteFromJsonElement(JsonElement element, List<VoiceChatMute> mutes, List<UUID> unmutes) {
        if (!element.isJsonObject()) {
            return;
        }
        JsonObject mutePlayer = element.getAsJsonObject();
        if (!mutePlayer.has("mute") || !mutePlayer.has("target")) {
            return;
        }
        boolean muted = mutePlayer.get("mute").getAsBoolean();
        UUID target = UUID.fromString(mutePlayer.get("target").getAsString());
        if (!muted) {
            unmutes.add(target);
            return;
        }
        mutes.add(VoiceChatMute.create((UUID)target, null));
    }
}

