/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.ui.activity.channel.widget;

import net.labymod.addons.voicechat.api.ui.VoiceChatTextures;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.screen.ScreenContext;
import net.labymod.api.client.gui.screen.state.ScreenCanvas;
import net.labymod.api.client.gui.screen.state.UVCoordinates;
import net.labymod.api.client.gui.screen.state.states.GuiTextureSet;
import net.labymod.api.client.gui.screen.widget.attributes.bounds.BoundsType;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.resources.ResourceLocation;
import net.labymod.api.laby3d.pipeline.RenderStates;
import net.labymod.api.util.bounds.ReasonableMutableRectangle;
import org.jetbrains.annotations.NotNull;

@AutoWidget
public class VoiceWindowWidget
extends FlexibleContentWidget {
    public void renderWidget(ScreenContext screenContext) {
        ScreenCanvas canvas = screenContext.canvas();
        ReasonableMutableRectangle bounds = this.bounds().rectangle(BoundsType.OUTER);
        float x = bounds.getX();
        float y = bounds.getY();
        float width = bounds.getWidth();
        float height = bounds.getHeight();
        int textureWidth = 64;
        int textureHeight = 64;
        int spriteWidth = 32;
        int spriteHeight = 64;
        int split = 3;
        float tileWidth = (float)spriteWidth / (float)split;
        float tileHeight = (float)spriteHeight / (float)split;
        GuiTextureSet textureSet = GuiTextureSet.single((ResourceLocation)VoiceChatTextures.SpriteWindow.TEXTURE);
        this.blitSegment(canvas, x, y, tileWidth, tileHeight, 0.0f, 0.0f, tileWidth, tileHeight, textureWidth, textureHeight, textureSet);
        this.blitSegment(canvas, x + tileWidth, y, width - tileWidth * 2.0f, tileHeight, tileWidth, 0.0f, tileWidth, tileHeight, textureWidth, textureHeight, textureSet);
        this.blitSegment(canvas, x + width - tileWidth, y, tileWidth, tileHeight, (float)spriteWidth - tileWidth, 0.0f, tileWidth, tileHeight, textureWidth, textureHeight, textureSet);
        this.blitSegment(canvas, x, y + tileHeight, tileWidth, height - tileHeight * 2.0f, 0.0f, tileHeight, tileWidth, tileHeight, textureWidth, textureHeight, textureSet);
        this.blitSegment(canvas, x + tileWidth, y + tileHeight, width - tileWidth * 2.0f, height - tileHeight * 2.0f, tileWidth, tileHeight, tileWidth, tileHeight, textureWidth, textureHeight, textureSet);
        this.blitSegment(canvas, x + width - tileWidth, y + tileHeight, tileWidth, height - tileHeight * 2.0f, (float)spriteWidth - tileWidth, tileHeight, tileWidth, tileHeight, textureWidth, textureHeight, textureSet);
        this.blitSegment(canvas, x, y + height - tileHeight, tileWidth, tileHeight, 0.0f, (float)spriteHeight - tileHeight, tileWidth, tileHeight, textureWidth, textureHeight, textureSet);
        this.blitSegment(canvas, x + tileWidth, y + height - tileHeight, width - tileWidth * 2.0f, tileHeight, tileWidth, (float)spriteHeight - tileHeight, tileWidth, tileHeight, textureWidth, textureHeight, textureSet);
        this.blitSegment(canvas, x + width - tileWidth, y + height - tileHeight, tileWidth, tileHeight, (float)spriteWidth - tileWidth, (float)spriteHeight - tileHeight, tileWidth, tileHeight, textureWidth, textureHeight, textureSet);
        super.renderWidget(screenContext);
    }

    private void blitSegment(@NotNull ScreenCanvas canvas, float x, float y, float w, float h, float u, float v, float uw, float uh, int texWidth, int texHeight, @NotNull GuiTextureSet textureSet) {
        canvas.submitGuiBlit(RenderStates.GUI_TEXTURED, textureSet, x, y, w, h, UVCoordinates.of((float)u, (float)v, (float)uw, (float)uh, (int)texWidth, (int)texHeight), -1);
    }
}

