/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.ui.activity.rules;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Locale;
import java.util.function.Consumer;
import net.labymod.addons.voicechat.core.VoiceChatAddon;
import net.labymod.addons.voicechat.core.configuration.DefaultVoiceChatConfiguration;
import net.labymod.api.Laby;
import net.labymod.api.Textures;
import net.labymod.api.client.Minecraft;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.activity.AutoActivity;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.activity.types.SimpleActivity;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.Document;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.ScrollWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.VerticalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;
import net.labymod.api.util.io.web.request.Request;
import net.labymod.api.util.io.web.request.types.GsonRequest;
import net.labymod.api.util.time.TimeUtil;

@Link(value="voicechat-rules.lss")
@AutoActivity
public class VoiceChatRulesActivity
extends SimpleActivity {
    public static final String URL_VOICE_RULES = "https://labymod.net/api/voicechat/rules/%s";
    public static long CURRENT_RULE_TIMESTAMP = 1702501475669L;
    public static JsonObject CACHED_RULES = null;
    private final JsonObject rules;

    public VoiceChatRulesActivity(JsonObject rules) {
        this.rules = rules;
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        FlexibleContentWidget windowWidget = new FlexibleContentWidget();
        windowWidget.addId("window");
        HorizontalListWidget header = new HorizontalListWidget();
        header.addId("header");
        ComponentWidget titleWidget = ComponentWidget.i18n((String)"voicechat.activity.rules.title");
        titleWidget.addId("title");
        header.addEntry((Widget)titleWidget);
        IconWidget closeButton = new IconWidget(Textures.SpriteCommon.SMALL_X_WITH_SHADOW);
        closeButton.addId("close-button");
        closeButton.setPressable(() -> this.close(false));
        header.addEntry((Widget)closeButton);
        windowWidget.addContent((Widget)header);
        VerticalListWidget listWidget = new VerticalListWidget();
        listWidget.addId("content");
        try {
            if (this.rules.has("header")) {
                String headerString = this.rules.get("header").getAsString();
                ComponentWidget headerWidget = ComponentWidget.text((String)headerString);
                headerWidget.addId("note");
                listWidget.addChild((Widget)headerWidget);
            }
            if (this.rules.has("rules")) {
                JsonArray rules = this.rules.get("rules").getAsJsonArray();
                for (JsonElement element : rules) {
                    if (!(element instanceof JsonObject)) continue;
                    JsonObject rule = element.getAsJsonObject();
                    if (rule.has("title")) {
                        String titleString = rule.get("title").getAsString();
                        ComponentWidget titleWidget2 = ComponentWidget.text((String)titleString);
                        titleWidget2.addId("title");
                        listWidget.addChild((Widget)titleWidget2);
                    }
                    if (!rule.has("text")) continue;
                    String textString = rule.get("text").getAsString();
                    ComponentWidget textWidget = ComponentWidget.text((String)textString);
                    textWidget.addId("text");
                    listWidget.addChild((Widget)textWidget);
                }
            }
            if (this.rules.has("footer")) {
                String footerString = this.rules.get("footer").getAsString();
                ComponentWidget footerWidget = ComponentWidget.text((String)footerString);
                footerWidget.addId("note");
                listWidget.addChild((Widget)footerWidget);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String errorString = e.getMessage();
            ComponentWidget errorWidget = ComponentWidget.text((String)errorString);
            errorWidget.addId("note");
            listWidget.addChild((Widget)errorWidget);
        }
        ScrollWidget scrollWidget = new ScrollWidget(listWidget);
        scrollWidget.addId("scroll");
        windowWidget.addFlexibleContent((Widget)scrollWidget);
        HorizontalListWidget footer = new HorizontalListWidget();
        footer.addId("footer");
        ButtonWidget acceptButton = ButtonWidget.i18n((String)"voicechat.activity.rules.accept");
        acceptButton.addId("accept-button");
        acceptButton.setPressable(() -> this.close(true));
        footer.addEntry((Widget)acceptButton);
        windowWidget.addContent((Widget)footer);
        ((Document)this.document).addChild((Widget)windowWidget);
    }

    private void close(boolean accepted) {
        if (accepted) {
            VoiceChatAddon addon = VoiceChatAddon.INSTANCE;
            ((DefaultVoiceChatConfiguration)addon.configuration()).timeRulesAccepted().set((Object)TimeUtil.getCurrentTimeMillis());
            addon.saveConfiguration();
        }
        this.displayPreviousScreen();
    }

    public static void create(Consumer<VoiceChatRulesActivity> callback) {
        Minecraft minecraft = Laby.labyAPI().minecraft();
        if (CACHED_RULES != null) {
            minecraft.executeNextTick(() -> callback.accept(new VoiceChatRulesActivity(CACHED_RULES)));
            return;
        }
        String language = minecraft.options().getCurrentLanguage().toLowerCase(Locale.ENGLISH);
        ((GsonRequest)((GsonRequest)((GsonRequest)((GsonRequest)Request.ofGson(JsonObject.class).url(URL_VOICE_RULES.formatted(language), new Object[0])).async()).connectTimeout(3000)).readTimeout(3000)).execute(response -> {
            if (response.getStatusCode() != 200 || response.hasException()) {
                callback.accept(null);
                return;
            }
            minecraft.executeNextTick(() -> {
                CACHED_RULES = (JsonObject)response.get();
                callback.accept(new VoiceChatRulesActivity(CACHED_RULES));
            });
        });
    }
}

