/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.voicechat.core.ui.activity.user.widget;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import net.labymod.addons.voicechat.api.VoiceChat;
import net.labymod.addons.voicechat.api.client.transmitter.VoiceTransmitter;
import net.labymod.addons.voicechat.api.client.user.VoiceUser;
import net.labymod.addons.voicechat.api.client.user.moderate.Mute;
import net.labymod.addons.voicechat.api.client.user.moderate.MuteCategory;
import net.labymod.addons.voicechat.api.client.user.moderate.MuteTemplate;
import net.labymod.addons.voicechat.api.client.user.moderate.Report;
import net.labymod.addons.voicechat.core.VoiceChatAddon;
import net.labymod.addons.voicechat.core.client.user.DefaultVoiceUser;
import net.labymod.addons.voicechat.core.ui.activity.user.widget.MuteTemplateEntryRenderer;
import net.labymod.api.Textures;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.event.HoverEvent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.component.format.TextDecoration;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.DivWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.TextFieldWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.dropdown.DropdownWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.dropdown.renderer.EntryRenderer;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.ScrollWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.VerticalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;
import net.labymod.api.util.TimeUnit;
import net.labymod.api.util.time.TimeUtil;

@AutoWidget
public class ModerationWidget
extends FlexibleContentWidget {
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    public static final SimpleDateFormat DATE_FORMAT_EXACT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final VoiceUser voiceUser;
    private final VoiceTransmitter transmitter;
    private final String username;
    private MuteTemplate selectedMuteTemplate = MuteTemplate.SOUNDBOARD;
    private TextFieldWidget durationWidget;
    private ButtonWidget muteButtonWidget;
    private ComponentWidget informationWidget;
    private DivWidget categoryReasonWrapper;
    private DropdownWidget<MuteCategory> categoryWidget;
    private TextFieldWidget reasonWidget;

    public ModerationWidget(VoiceChat voiceChat, VoiceUser voiceUser, String username) {
        MuteTemplate template;
        Report report;
        this.voiceUser = voiceUser;
        this.transmitter = voiceChat.referenceStorage().voiceConnector().transmitter();
        this.username = username;
        if (voiceUser instanceof DefaultVoiceUser && (report = ((DefaultVoiceUser)voiceUser).getHighlightedReport()) != null && (template = MuteTemplate.fromDisplayName(report.getReason())) != null) {
            this.selectedMuteTemplate = template;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Parent parent) {
        super.initialize(parent);
        VoiceUser voiceUser = this.voiceUser;
        synchronized (voiceUser) {
            FlexibleContentWidget splitHistory = new FlexibleContentWidget();
            splitHistory.addId("split-history");
            FlexibleContentWidget reportsWrapper = new FlexibleContentWidget();
            reportsWrapper.addId(new String[]{"history-wrapper", "reports-wrapper"});
            ComponentWidget reportsTitleWidget = ComponentWidget.component((Component)Component.translatable((String)"voicechat.activity.moderation.reports.title", (Component[])new Component[0]).args(new Component[]{Component.text((Object)this.voiceUser.getReports().size())}));
            reportsTitleWidget.addId(new String[]{"reports-title", "history-title"});
            reportsWrapper.addContent((Widget)reportsTitleWidget);
            VerticalListWidget reportsListWidget = new VerticalListWidget();
            reportsListWidget.addId(new String[]{"reports-list", "history"});
            for (Report report : this.voiceUser.getReports()) {
                Component component = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"- ").color(NamedTextColor.WHITE)).append(Component.text((String)report.getReason()).color(NamedTextColor.YELLOW))).append(Component.text((String)" (").color(NamedTextColor.GRAY))).append(Component.text((String)report.getReportedBy()).color(NamedTextColor.GOLD))).append(Component.text((String)")").color(NamedTextColor.GRAY));
                String serverAddress = report.getServerAddress();
                component.hoverEvent(HoverEvent.showText((Component)((TextComponent)((TextComponent)((TextComponent)Component.text((String)report.getReason()).color(NamedTextColor.YELLOW)).append((Component)Component.text((String)" "))).append(Component.text((String)(serverAddress != null ? serverAddress : "Unknown")).color(NamedTextColor.WHITE))).append(Component.text((String)"\n").append(Component.text((String)(DATE_FORMAT_EXACT.format(new Date(report.getReportedAt())) + " (" + report.getReportedBy() + ")")).color(NamedTextColor.GRAY)))));
                ComponentWidget reportWidget = ComponentWidget.component((Component)component);
                reportWidget.addId(new String[]{"report", "history-entry"});
                reportsListWidget.addChild((Widget)reportWidget);
            }
            ScrollWidget scrollWidget = new ScrollWidget(reportsListWidget);
            scrollWidget.addId("scroll");
            reportsWrapper.addFlexibleContent((Widget)scrollWidget);
            splitHistory.addContent((Widget)reportsWrapper);
            FlexibleContentWidget mutesWrapper = new FlexibleContentWidget();
            mutesWrapper.addId(new String[]{"history-wrapper", "mutes-wrapper"});
            long totalMuteDuration = 0L;
            for (Mute mute : this.voiceUser.getMutes()) {
                if (mute.isUnmutedManually()) continue;
                totalMuteDuration += mute.getDuration();
            }
            ComponentWidget reportsTitleWidget2 = ComponentWidget.component((Component)Component.translatable((String)"voicechat.activity.moderation.mutes.title", (Component[])new Component[]{Component.text((Object)this.voiceUser.getMutes().size())}).hoverEvent(HoverEvent.showText((Component)Component.text((String)TimeUnit.parseToString((long)totalMuteDuration)))));
            reportsTitleWidget2.addId(new String[]{"mutes-title", "history-title"});
            mutesWrapper.addContent((Widget)reportsTitleWidget2);
            VerticalListWidget mutesListWidget = new VerticalListWidget();
            mutesListWidget.addId(new String[]{"mutes-list", "history"});
            for (Mute mute : this.voiceUser.getMutes()) {
                String muteDate = DATE_FORMAT.format(new Date(mute.getTimeStart()));
                String duration = TimeUnit.parseToString((long)(mute.getTimeEnd() - mute.getTimeStart()));
                TextColor muteColor = mute.isActive() ? (mute.isIpMute() ? NamedTextColor.AQUA : NamedTextColor.RED) : (mute.isUnmutedManually() ? NamedTextColor.DARK_GRAY : NamedTextColor.GRAY);
                String moderatorName = mute.getMutedByName();
                String unmutedByName = mute.getUnmutedByName();
                Component reasonLine = Component.text((String)mute.getReason()).color(NamedTextColor.YELLOW);
                if (mute.isUnmutedManually()) {
                    reasonLine.decorate(TextDecoration.STRIKETHROUGH);
                }
                Component component = ((TextComponent)Component.text((String)"- ").color(NamedTextColor.WHITE)).append(reasonLine);
                Component moderatorNameComponent = Component.text((String)moderatorName).color(NamedTextColor.GOLD);
                if (mute.isUnmutedManually() && !Objects.equals(moderatorName, unmutedByName)) {
                    Component unmutedByNameComponent = Component.text((String)unmutedByName).color(NamedTextColor.GOLD);
                    moderatorNameComponent.append(Component.text((String)" & ").color(NamedTextColor.GRAY)).append(unmutedByNameComponent);
                }
                component.append(Component.text((String)" (").color(NamedTextColor.GRAY)).append(moderatorNameComponent).append(Component.text((String)")").color(NamedTextColor.GRAY));
                component.append(Component.text((String)("\n  " + muteDate)).color(muteColor)).append(Component.text((String)" (").color(muteColor)).append(Component.text((String)duration).color(muteColor)).append(Component.text((String)")").color(muteColor));
                component.hoverEvent(HoverEvent.showText((Component)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)mute.getReason()).color(NamedTextColor.YELLOW)).append(Component.text((String)(" (" + duration + ")")).color(NamedTextColor.GRAY))).append(Component.text((String)"\n\u00bb ").color(NamedTextColor.GREEN))).append(Component.text((String)(DATE_FORMAT_EXACT.format(new Date(mute.getTimeStart())) + " (" + mute.getMutedByName() + ")\n")).color(NamedTextColor.GRAY))).append(Component.text((String)"\u00ab ").color(NamedTextColor.RED))).append(Component.text((String)(DATE_FORMAT_EXACT.format(new Date(mute.getTimeEnd())) + (String)(mute.isUnmutedManually() ? " (" + unmutedByName + ")" : ""))).color(NamedTextColor.GRAY))).append((Component)(mute.isIpMute() ? Component.text((String)("\n" + mute.getMainUsername())).color(NamedTextColor.AQUA) : Component.empty()))));
                ComponentWidget muteWidget = ComponentWidget.component((Component)component);
                muteWidget.addId(new String[]{"mute", "history-entry"});
                mutesListWidget.addChild((Widget)muteWidget);
            }
            ScrollWidget scrollWidget2 = new ScrollWidget(mutesListWidget);
            scrollWidget2.addId("scroll");
            mutesWrapper.addFlexibleContent((Widget)scrollWidget2);
            splitHistory.addFlexibleContent((Widget)mutesWrapper);
            this.addFlexibleContent((Widget)splitHistory);
            FlexibleContentWidget muteActionsWrapper = new FlexibleContentWidget();
            muteActionsWrapper.addId("mute-actions-wrapper");
            HorizontalListWidget titleWrapper = new HorizontalListWidget();
            titleWrapper.addId("mute-title-wrapper");
            ComponentWidget titleWidget = ComponentWidget.i18n((String)"voicechat.activity.moderation.moderation.title");
            titleWidget.addId("title");
            titleWrapper.addEntry((Widget)titleWidget);
            IconWidget hideButtonWidget = new IconWidget(Textures.SpriteCommon.SMALL_X_WITH_SHADOW);
            hideButtonWidget.addId("hide-button");
            hideButtonWidget.setHoverComponent((Component)Component.translatable((String)"voicechat.activity.moderation.moderation.hide", (Component[])new Component[0]));
            hideButtonWidget.setPressable(() -> muteActionsWrapper.setVisible(false));
            titleWrapper.addEntry((Widget)hideButtonWidget);
            muteActionsWrapper.addContent((Widget)titleWrapper);
            Mute mute = this.voiceUser.getMute();
            if (mute.isActive()) {
                this.informationWidget = ComponentWidget.empty();
                this.informationWidget.addId("information");
                muteActionsWrapper.addContent((Widget)this.informationWidget);
                this.updateMuteInformation();
                ButtonWidget unmuteButtonWidget = ButtonWidget.component((Component)Component.translatable((String)"voicechat.activity.moderation.moderation.unmute", (Component[])new Component[0]).color(NamedTextColor.RED));
                unmuteButtonWidget.addId(new String[]{"input", "unmute-button"});
                unmuteButtonWidget.setPressable(() -> {
                    this.transmitter.unmutePlayer(this.voiceUser.getUniqueId());
                    this.labyAPI.minecraft().chatExecutor().displayClientMessage(((TextComponent)((TextComponent)Component.empty().append(VoiceChatAddon.VOICE_CHAT_PREFIX)).append((Component)Component.text((String)" "))).append(Component.translatable((String)"voicechat.commands.unmute.admin.unmuted", (Component[])new Component[0]).args(new Component[]{Component.text((String)this.username)}).color(NamedTextColor.RED)));
                    this.labyAPI.minecraft().minecraftWindow().displayScreenRaw(null);
                });
                muteActionsWrapper.addContent((Widget)unmuteButtonWidget);
            } else {
                this.informationWidget = null;
                DropdownWidget templateWidget = new DropdownWidget();
                templateWidget.setChangeListener(template -> {
                    this.selectedMuteTemplate = template;
                    this.updateInputFields();
                });
                templateWidget.setEntryRenderer((EntryRenderer)new MuteTemplateEntryRenderer());
                templateWidget.addId(new String[]{"input", "template-dropdown"});
                templateWidget.addAll((Object[])MuteTemplate.values());
                templateWidget.setSelected((Object)this.selectedMuteTemplate);
                muteActionsWrapper.addContent((Widget)templateWidget);
                this.categoryReasonWrapper = new DivWidget();
                this.categoryReasonWrapper.addId(new String[]{"input", "category-reason-wrapper"});
                List<MuteCategory> categories = this.voiceUser.getMuteCategories();
                this.categoryWidget = new DropdownWidget();
                this.categoryWidget.setChangeListener(category -> this.updateInputFields());
                this.categoryWidget.addId(new String[]{"input", "category-dropdown"});
                this.categoryWidget.addAll(categories);
                if (!categories.isEmpty()) {
                    this.categoryWidget.setSelected((Object)categories.get(0));
                }
                this.categoryReasonWrapper.addChild(this.categoryWidget);
                this.reasonWidget = new TextFieldWidget();
                this.reasonWidget.addId(new String[]{"input", "reason-input"});
                this.reasonWidget.setActionListener(this::updateMuteButton);
                this.categoryReasonWrapper.addChild((Widget)this.reasonWidget);
                muteActionsWrapper.addContent((Widget)this.categoryReasonWrapper);
                this.durationWidget = new TextFieldWidget();
                this.durationWidget.addId(new String[]{"input", "duration-input"});
                this.durationWidget.setActionListener(this::updateMuteButton);
                muteActionsWrapper.addContent((Widget)this.durationWidget);
                this.muteButtonWidget = ButtonWidget.component((Component)Component.translatable((String)"voicechat.activity.moderation.moderation.mute", (Component[])new Component[0]).color(NamedTextColor.RED));
                this.muteButtonWidget.addId(new String[]{"input", "mute-button"});
                this.muteButtonWidget.setPressable(() -> {
                    String reason = this.getMuteReason();
                    long duration = TimeUnit.parseToLong((String)this.durationWidget.getText());
                    duration = this.transmitter.mutePlayer(this.voiceUser.getUniqueId(), reason, duration);
                    this.labyAPI.minecraft().chatExecutor().displayClientMessage(((TextComponent)((TextComponent)Component.empty().append(VoiceChatAddon.VOICE_CHAT_PREFIX)).append((Component)Component.text((String)" "))).append(Component.translatable((String)"voicechat.commands.mute.admin.muted", (Component[])new Component[0]).args(new Component[]{Component.text((String)this.username), Component.text((String)TimeUnit.parseToString((long)duration)), Component.text((String)reason)}).color(NamedTextColor.RED)));
                    this.labyAPI.minecraft().minecraftWindow().displayScreenRaw(null);
                });
                muteActionsWrapper.addContent((Widget)this.muteButtonWidget);
            }
            this.addContent((Widget)muteActionsWrapper);
            this.updateInputFields();
        }
    }

    public void tick() {
        super.tick();
        this.updateMuteInformation();
    }

    private void updateInputFields() {
        if (this.reasonWidget != null && this.durationWidget != null && this.categoryWidget != null) {
            boolean editable = this.selectedMuteTemplate == MuteTemplate.CUSTOM;
            MuteCategory category = (MuteCategory)this.categoryWidget.getSelected();
            if (category != null && !editable) {
                long duration = category.getDuration();
                this.durationWidget.setText(TimeUnit.parseToString((long)duration));
            }
            this.reasonWidget.setEditable(editable);
            this.durationWidget.setEditable(editable);
            this.reasonWidget.setVisible(editable);
            this.categoryWidget.setVisible(!editable);
            this.updateMuteButton();
        }
    }

    private void updateMuteButton() {
        if (this.muteButtonWidget == null) {
            return;
        }
        String reason = this.getMuteReason();
        this.muteButtonWidget.setEnabled(reason.length() > 3 && TimeUnit.parseToLong((String)this.durationWidget.getText()) > 0L);
    }

    private void updateMuteInformation() {
        Mute mute = this.voiceUser.getMute();
        if (this.informationWidget != null && !mute.isActive()) {
            this.reInitialize();
            return;
        }
        long duration = mute.getTimeEnd() - TimeUtil.getCurrentTimeMillis();
        TextColor color = mute.isIpMute() ? NamedTextColor.AQUA : NamedTextColor.YELLOW;
        Component component = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(Component.text((String)"Muted by").color(NamedTextColor.GRAY))).append(Component.text((String)": ").color(NamedTextColor.DARK_GRAY))).append(Component.text((String)mute.getMutedByName()).color(color))).append((Component)Component.newline())).append(Component.text((String)"Reason").color(NamedTextColor.GRAY))).append(Component.text((String)": ").color(NamedTextColor.DARK_GRAY))).append(Component.text((String)mute.getReason()).color(color))).append((Component)Component.newline())).append(Component.text((String)"Time left").color(NamedTextColor.GRAY))).append(Component.text((String)": ").color(NamedTextColor.DARK_GRAY))).append(Component.text((String)TimeUnit.parseToString((long)duration)).color(color))).append((Component)Component.newline())).append(Component.text((String)"Muted until").color(NamedTextColor.GRAY))).append(Component.text((String)": ").color(NamedTextColor.DARK_GRAY))).append(((TextComponent)Component.text((String)DATE_FORMAT.format(new Date(mute.getTimeEnd()))).color(color)).hoverEvent(HoverEvent.showText((Component)Component.text((String)DATE_FORMAT_EXACT.format(new Date(mute.getTimeEnd()))))));
        if (mute.isIpMute()) {
            component.append((Component)Component.newline()).append(Component.text((String)"Main").color(NamedTextColor.GRAY)).append(Component.text((String)": ").color(NamedTextColor.DARK_GRAY)).append(Component.text((String)mute.getMainUsername()).color(color));
        }
        if (this.informationWidget != null) {
            this.informationWidget.setComponent(component);
        }
    }

    private String getMuteReason() {
        return this.selectedMuteTemplate == MuteTemplate.CUSTOM ? this.reasonWidget.getText() : this.selectedMuteTemplate.getIdentifier();
    }
}

